/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.EncDecProperties;
import org.apache.parquet.hadoop.util.EncryptionTestFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TestFileBuilder {
    private static final char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
    private static final ThreadLocalRandom random = ThreadLocalRandom.current();
    private final MessageType schema;
    private final Configuration conf;
    private Map<String, String> extraMeta = new HashMap<String, String>();
    private int numRecord = 100000;
    private ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
    private int pageSize = 0x100000;
    private String codec = "ZSTD";
    private String[] encryptColumns = new String[0];
    private ParquetCipher cipher = ParquetCipher.AES_GCM_V1;
    private Boolean footerEncryption = false;
    private long rowGroupSize = 0x8000000L;
    private String[] bloomFilterEnabled = new String[0];

    public TestFileBuilder(Configuration conf, MessageType schema) {
        this.conf = conf;
        this.schema = schema;
        conf.set("parquet.example.schema", schema.toString());
    }

    public TestFileBuilder withNumRecord(int numRecord) {
        this.numRecord = numRecord;
        return this;
    }

    public TestFileBuilder withEncrytionAlgorithm(ParquetCipher cipher) {
        this.cipher = cipher;
        return this;
    }

    public TestFileBuilder withExtraMeta(Map<String, String> extraMeta) {
        this.extraMeta = extraMeta;
        return this;
    }

    public TestFileBuilder withWriterVersion(ParquetProperties.WriterVersion writerVersion) {
        this.writerVersion = writerVersion;
        return this;
    }

    public TestFileBuilder withPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public TestFileBuilder withCodec(String codec) {
        this.codec = codec;
        return this;
    }

    public TestFileBuilder withEncryptColumns(String[] encryptColumns) {
        this.encryptColumns = encryptColumns;
        return this;
    }

    public TestFileBuilder withFooterEncryption() {
        this.footerEncryption = true;
        return this;
    }

    public TestFileBuilder withRowGroupSize(long rowGroupSize) {
        this.rowGroupSize = rowGroupSize;
        return this;
    }

    public TestFileBuilder withBloomFilterEnabled(String[] bloomFilterEnabled) {
        this.bloomFilterEnabled = bloomFilterEnabled;
        return this;
    }

    public EncryptionTestFile build() throws IOException {
        String fileName = TestFileBuilder.createTempFile("test");
        SimpleGroup[] fileContent = this.createFileContent(this.schema);
        FileEncryptionProperties encryptionProperties = EncDecProperties.getFileEncryptionProperties(this.encryptColumns, this.cipher, this.footerEncryption);
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(fileName)).withConf(this.conf)).withWriterVersion(this.writerVersion)).withExtraMetaData(this.extraMeta).withValidation(true)).withPageSize(this.pageSize)).withRowGroupSize(this.rowGroupSize)).withEncryption(encryptionProperties)).withCompressionCodec(CompressionCodecName.valueOf((String)this.codec));
        for (String columnPath : this.bloomFilterEnabled) {
            builder.withBloomFilterEnabled(columnPath, true);
        }
        try (ParquetWriter writer = builder.build();){
            for (SimpleGroup simpleGroup : fileContent) {
                writer.write((Object)simpleGroup);
            }
        }
        return new EncryptionTestFile(fileName, fileContent);
    }

    private SimpleGroup[] createFileContent(MessageType schema) {
        SimpleGroup[] simpleGroups = new SimpleGroup[this.numRecord];
        for (int i = 0; i < simpleGroups.length; ++i) {
            SimpleGroup g = new SimpleGroup((GroupType)schema);
            for (Type type : schema.getFields()) {
                this.addValueToSimpleGroup((Group)g, type);
            }
            simpleGroups[i] = g;
        }
        return simpleGroups;
    }

    private void addValueToSimpleGroup(Group g, Type type) {
        if (type.isPrimitive()) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            this.addPrimitiveValueToSimpleGroup(g, primitiveType);
        } else {
            GroupType groupType = (GroupType)type;
            Group parentGroup = g.addGroup(groupType.getName());
            for (Type field : groupType.getFields()) {
                this.addValueToSimpleGroup(parentGroup, field);
            }
        }
    }

    private void addPrimitiveValueToSimpleGroup(Group g, PrimitiveType primitiveType) {
        if (primitiveType.isRepetition(Type.Repetition.REPEATED)) {
            int listSize = random.nextInt(1, 10);
            for (int i = 0; i < listSize; ++i) {
                this.addSinglePrimitiveValueToSimpleGroup(g, primitiveType);
            }
        } else {
            this.addSinglePrimitiveValueToSimpleGroup(g, primitiveType);
        }
    }

    private void addSinglePrimitiveValueToSimpleGroup(Group g, PrimitiveType primitiveType) {
        if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
            g.add(primitiveType.getName(), TestFileBuilder.getInt());
        } else if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) {
            g.add(primitiveType.getName(), TestFileBuilder.getLong());
        } else if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) {
            g.add(primitiveType.getName(), TestFileBuilder.getString());
        } else if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.FLOAT)) {
            g.add(primitiveType.getName(), TestFileBuilder.getFloat());
        } else if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.DOUBLE)) {
            g.add(primitiveType.getName(), TestFileBuilder.getDouble());
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + primitiveType);
        }
    }

    private static long getInt() {
        return random.nextInt(10000);
    }

    private static long getLong() {
        return random.nextLong(100000L);
    }

    private static String getString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < random.nextInt(100); ++i) {
            sb.append(chars[random.nextInt(10)]);
        }
        return sb.toString();
    }

    private static float getFloat() {
        if (random.nextBoolean()) {
            return Float.NaN;
        }
        return random.nextFloat();
    }

    private static double getDouble() {
        if (random.nextBoolean()) {
            return Double.NaN;
        }
        return random.nextDouble();
    }

    public static String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }
}

