/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.util.H1SeekableInputStream;
import org.apache.parquet.hadoop.util.H2SeekableInputStream;
import org.apache.parquet.hadoop.util.HadoopStreams;
import org.apache.parquet.hadoop.util.MockHadoopInputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestHadoop2ByteBufferReads {
    @Test
    public void testHeapReadFullySmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(8);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyLargeBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        TestUtils.assertThrows("Should throw EOFException", EOFException.class, () -> {
            H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
            return null;
        });
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
    }

    @Test
    public void testHeapReadFullyJustRight() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullySmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.position(3);
        readBuffer.mark();
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.limit(7);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.position(3);
        readBuffer.limit(7);
        readBuffer.mark();
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 4), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullySmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(8);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyLargeBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        TestUtils.assertThrows("Should throw EOFException", EOFException.class, () -> {
            H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
            return null;
        });
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
    }

    @Test
    public void testDirectReadFullyJustRight() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullySmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.position(3);
        readBuffer.mark();
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.limit(7);
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.position(3);
        readBuffer.limit(7);
        readBuffer.mark();
        FSDataInputStream hadoopStream = new FSDataInputStream((InputStream)new MockHadoopInputStream(2, 3, 3));
        MockBufferReader reader = new MockBufferReader(hadoopStream);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 4), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        H2SeekableInputStream.readFully((H2SeekableInputStream.Reader)reader, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockHadoopInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testCreateStreamNoByteBufferReadable() {
        SeekableInputStream s = HadoopStreams.wrap((FSDataInputStream)new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0])));
        Assert.assertTrue((String)("Wrong wrapper: " + s), (boolean)(s instanceof H1SeekableInputStream));
    }

    @Test
    public void testDoubleWrapNoByteBufferReadable() {
        SeekableInputStream s = HadoopStreams.wrap((FSDataInputStream)new FSDataInputStream((InputStream)new FSDataInputStream((InputStream)new MockHadoopInputStream(new int[0]))));
        Assert.assertTrue((String)("Wrong wrapper: " + s), (boolean)(s instanceof H1SeekableInputStream));
    }

    @Test
    public void testCreateStreamWithByteBufferReadable() {
        SeekableInputStream s = HadoopStreams.wrap((FSDataInputStream)new FSDataInputStream((InputStream)new MockByteBufferInputStream()));
        Assert.assertTrue((String)("Wrong wrapper: " + s), (boolean)(s instanceof H2SeekableInputStream));
    }

    @Test
    public void testDoubleWrapByteBufferReadable() {
        SeekableInputStream s = HadoopStreams.wrap((FSDataInputStream)new FSDataInputStream((InputStream)new FSDataInputStream((InputStream)new MockByteBufferInputStream())));
        Assert.assertTrue((String)("Wrong wrapper: " + s), (boolean)(s instanceof H2SeekableInputStream));
    }

    private static final class MockByteBufferInputStream
    extends MockHadoopInputStream
    implements ByteBufferReadable {
        private MockByteBufferInputStream() {
            super(new int[0]);
        }

        public int read(ByteBuffer buf) {
            return 0;
        }
    }

    private static class MockBufferReader
    implements H2SeekableInputStream.Reader {
        private final FSDataInputStream stream;

        public MockBufferReader(FSDataInputStream stream) {
            this.stream = stream;
        }

        public int read(ByteBuffer buf) throws IOException {
            byte[] temp = new byte[buf.remaining()];
            int bytesRead = this.stream.read(temp, 0, temp.length);
            if (bytesRead > 0) {
                buf.put(temp, 0, bytesRead);
            }
            return bytesRead;
        }
    }
}

