/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cmap;

public class CodespaceRange {
    private byte[] start;
    private byte[] end;
    private int startInt;
    private int endInt;
    private int codeLength = 0;

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getEnd() {
        return this.end;
    }

    void setEnd(byte[] endBytes) {
        this.end = endBytes;
        this.endInt = this.toInt(endBytes, endBytes.length);
    }

    public byte[] getStart() {
        return this.start;
    }

    void setStart(byte[] startBytes) {
        this.start = startBytes;
        this.codeLength = this.start.length;
        this.startInt = this.toInt(startBytes, startBytes.length);
    }

    public boolean matches(byte[] code) {
        return this.isFullMatch(code, code.length);
    }

    private int toInt(byte[] data, int dataLen) {
        int code = 0;
        for (int i = 0; i < dataLen; ++i) {
            code <<= 8;
            code |= (data[i] + 256) % 256;
        }
        return code;
    }

    public boolean isFullMatch(byte[] code, int codeLen) {
        int value;
        return codeLen == this.codeLength && (value = this.toInt(code, codeLen)) >= this.startInt && value <= this.endInt;
    }
}

