/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSParser;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.io.ScratchFile;

public class COSDocument
extends COSBase
implements Closeable {
    private static final Log LOG = LogFactory.getLog(COSDocument.class);
    private float version = 1.4f;
    private final Map<COSObjectKey, COSObject> objectPool = new HashMap<COSObjectKey, COSObject>();
    private final Map<COSObjectKey, Long> xrefTable = new HashMap<COSObjectKey, Long>();
    private final List<COSStream> streams = new ArrayList<COSStream>();
    private COSDictionary trailer;
    private boolean isDecrypted = false;
    private long startXref;
    private boolean closed = false;
    private boolean isXRefStream;
    private ScratchFile scratchFile;
    private long highestXRefObjectNumber;
    private final ICOSParser parser;

    public COSDocument() {
        this(MemoryUsageSetting.setupMainMemoryOnly());
    }

    public COSDocument(ICOSParser parser) {
        this(MemoryUsageSetting.setupMainMemoryOnly(), parser);
    }

    public COSDocument(MemoryUsageSetting memUsageSetting) {
        this(memUsageSetting, null);
    }

    public COSDocument(MemoryUsageSetting memUsageSetting, ICOSParser parser) {
        try {
            this.scratchFile = memUsageSetting != null ? new ScratchFile(memUsageSetting) : ScratchFile.getMainMemoryOnlyInstance();
        }
        catch (IOException ioe) {
            LOG.warn("Error initializing scratch file: " + ioe.getMessage() + ". Fall back to main memory usage only.", ioe);
            this.scratchFile = ScratchFile.getMainMemoryOnlyInstance();
        }
        this.parser = parser;
    }

    public COSStream createCOSStream() {
        COSStream stream = new COSStream(this.scratchFile);
        this.streams.add(stream);
        return stream;
    }

    public COSStream createCOSStream(COSDictionary dictionary, long startPosition, long streamLength) throws IOException {
        COSStream stream = new COSStream(this.scratchFile, this.parser.createRandomAccessReadView(startPosition, streamLength));
        dictionary.forEach(stream::setItem);
        return stream;
    }

    public COSDictionary getLinearizedDictionary() {
        List objectKeys = this.xrefTable.entrySet().stream().filter(e -> (Long)e.getValue() > 0L).sorted(Comparator.comparing(Map.Entry::getValue)).map(Map.Entry::getKey).collect(Collectors.toList());
        for (COSObjectKey objectKey : objectKeys) {
            COSDictionary dic;
            COSObject objectFromPool = this.getObjectFromPool(objectKey);
            COSBase realObject = objectFromPool.getObject();
            if (!(realObject instanceof COSDictionary) || (dic = (COSDictionary)realObject).getItem(COSName.LINEARIZED) == null) continue;
            return dic;
        }
        return null;
    }

    public List<COSObject> getObjectsByType(COSName type) {
        return this.getObjectsByType(type, null);
    }

    public List<COSObject> getObjectsByType(COSName type1, COSName type2) {
        ArrayList<COSObject> retval = new ArrayList<COSObject>();
        for (COSObjectKey objectKey : this.xrefTable.keySet()) {
            COSName dictType;
            COSObject objectFromPool = this.getObjectFromPool(objectKey);
            COSBase realObject = objectFromPool.getObject();
            if (!(realObject instanceof COSDictionary) || !type1.equals(dictType = ((COSDictionary)realObject).getCOSName(COSName.TYPE)) && (type2 == null || !type2.equals(dictType))) continue;
            retval.add(objectFromPool);
        }
        return retval;
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public void setDecrypted() {
        this.isDecrypted = true;
    }

    public boolean isDecrypted() {
        return this.isDecrypted;
    }

    public boolean isEncrypted() {
        return this.trailer != null && this.trailer.getCOSDictionary(COSName.ENCRYPT) != null;
    }

    public COSDictionary getEncryptionDictionary() {
        return this.trailer.getCOSDictionary(COSName.ENCRYPT);
    }

    public void setEncryptionDictionary(COSDictionary encDictionary) {
        this.trailer.setItem(COSName.ENCRYPT, (COSBase)encDictionary);
    }

    public COSArray getDocumentID() {
        return this.getTrailer().getCOSArray(COSName.ID);
    }

    public void setDocumentID(COSArray id) {
        this.getTrailer().setItem(COSName.ID, (COSBase)id);
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    public long getHighestXRefObjectNumber() {
        return this.highestXRefObjectNumber;
    }

    public void setHighestXRefObjectNumber(long highestXRefObjectNumber) {
        this.highestXRefObjectNumber = highestXRefObjectNumber;
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromDocument(this);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        IOException firstException = null;
        for (COSObject object : this.objectPool.values()) {
            COSBase cosObject;
            if (object.isObjectNull() || !((cosObject = object.getObject()) instanceof COSStream)) continue;
            firstException = IOUtils.closeAndLogException((COSStream)cosObject, LOG, "COSStream", firstException);
        }
        for (COSStream stream : this.streams) {
            firstException = IOUtils.closeAndLogException(stream, LOG, "COSStream", firstException);
        }
        if (this.scratchFile != null) {
            firstException = IOUtils.closeAndLogException(this.scratchFile, LOG, "ScratchFile", firstException);
        }
        this.closed = true;
        if (firstException != null) {
            throw firstException;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public COSObject getObjectFromPool(COSObjectKey key) {
        COSObject obj = null;
        if (key != null) {
            obj = this.objectPool.computeIfAbsent(key, k -> new COSObject((COSObjectKey)k, this.parser));
        }
        return obj;
    }

    public void addXRefTable(Map<COSObjectKey, Long> xrefTableValues) {
        this.xrefTable.putAll(xrefTableValues);
    }

    public Map<COSObjectKey, Long> getXrefTable() {
        return this.xrefTable;
    }

    public void setStartXref(long startXrefValue) {
        this.startXref = startXrefValue;
    }

    public long getStartXref() {
        return this.startXref;
    }

    public boolean isXRefStream() {
        return this.isXRefStream;
    }

    public void setIsXRefStream(boolean isXRefStreamValue) {
        this.isXRefStream = isXRefStreamValue;
    }
}

