/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDInkAppearanceHandler;

public class PDAnnotationInk
extends PDAnnotationMarkup {
    public static final String SUB_TYPE = "Ink";
    private PDAppearanceHandler customAppearanceHandler;

    public PDAnnotationInk() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationInk(COSDictionary dict) {
        super(dict);
    }

    public void setInkList(float[][] inkList) {
        if (inkList == null) {
            this.getCOSObject().removeItem(COSName.INKLIST);
            return;
        }
        COSArray array = new COSArray();
        for (float[] path : inkList) {
            COSArray innerArray = new COSArray();
            innerArray.setFloatArray(path);
            array.add(innerArray);
        }
        this.getCOSObject().setItem(COSName.INKLIST, (COSBase)array);
    }

    public float[][] getInkList() {
        COSArray array = this.getCOSObject().getCOSArray(COSName.INKLIST);
        if (array != null) {
            float[][] inkList = new float[array.size()][];
            for (int i = 0; i < array.size(); ++i) {
                COSBase base2 = array.getObject(i);
                inkList[i] = base2 instanceof COSArray ? ((COSArray)array.getObject(i)).toFloatArray() : new float[0];
            }
            return inkList;
        }
        return new float[0][0];
    }

    public void setCustomAppearanceHandler(PDAppearanceHandler appearanceHandler) {
        this.customAppearanceHandler = appearanceHandler;
    }

    @Override
    public void constructAppearances() {
        this.constructAppearances(null);
    }

    @Override
    public void constructAppearances(PDDocument document) {
        if (this.customAppearanceHandler == null) {
            PDInkAppearanceHandler appearanceHandler = new PDInkAppearanceHandler(this, document);
            appearanceHandler.generateAppearanceStreams();
        } else {
            this.customAppearanceHandler.generateAppearanceStreams();
        }
    }
}

