/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public final class Encrypt {
    private Encrypt() {
    }

    public static void main(String[] args) throws IOException, CertificateException {
        System.setProperty("apple.awt.UIElement", "true");
        Encrypt encrypt = new Encrypt();
        encrypt.encrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encrypt(String[] args) throws IOException, CertificateException {
        block33: {
            if (args.length < 1) {
                Encrypt.usage();
            } else {
                AccessPermission ap = new AccessPermission();
                String infile = null;
                String outfile = null;
                String certFile = null;
                String userPassword = "";
                String ownerPassword = "";
                int keyLength = 40;
                PDDocument document = null;
                try {
                    for (int i = 0; i < args.length; ++i) {
                        String key = args[i];
                        if (key.equals("-O")) {
                            ownerPassword = args[++i];
                            continue;
                        }
                        if (key.equals("-U")) {
                            userPassword = args[++i];
                            continue;
                        }
                        if (key.equals("-canAssemble")) {
                            ap.setCanAssembleDocument(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canExtractContent")) {
                            ap.setCanExtractContent(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canExtractForAccessibility")) {
                            ap.setCanExtractForAccessibility(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canFillInForm")) {
                            ap.setCanFillInForm(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canModify")) {
                            ap.setCanModify(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canModifyAnnotations")) {
                            ap.setCanModifyAnnotations(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canPrint")) {
                            ap.setCanPrint(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canPrintDegraded")) {
                            ap.setCanPrintDegraded(args[++i].equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-certFile")) {
                            certFile = args[++i];
                            continue;
                        }
                        if (key.equals("-keyLength")) {
                            try {
                                keyLength = Integer.parseInt(args[++i]);
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Error: -keyLength is not an integer '" + args[i] + "'");
                            }
                        }
                        if (infile == null) {
                            infile = key;
                            continue;
                        }
                        if (outfile == null) {
                            outfile = key;
                            continue;
                        }
                        Encrypt.usage();
                    }
                    if (infile == null) {
                        Encrypt.usage();
                    }
                    if (outfile == null) {
                        outfile = infile;
                    }
                    if (!(document = PDDocument.load((File)new File(infile))).isEncrypted()) {
                        if (certFile != null) {
                            PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
                            PublicKeyRecipient recip = new PublicKeyRecipient();
                            recip.setPermission(ap);
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            FileInputStream inStream = null;
                            try {
                                inStream = new FileInputStream(certFile);
                                X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                                recip.setX509(certificate);
                            }
                            finally {
                                if (inStream != null) {
                                    ((InputStream)inStream).close();
                                }
                            }
                            ppp.addRecipient(recip);
                            ppp.setEncryptionKeyLength(keyLength);
                            document.protect((ProtectionPolicy)ppp);
                        } else {
                            StandardProtectionPolicy spp = new StandardProtectionPolicy(ownerPassword, userPassword, ap);
                            spp.setEncryptionKeyLength(keyLength);
                            document.protect((ProtectionPolicy)spp);
                        }
                        document.save(outfile);
                        break block33;
                    }
                    System.err.println("Error: Document is already encrypted.");
                }
                finally {
                    if (document != null) {
                        document.close();
                    }
                }
            }
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar Encrypt [options] <inputfile> [outputfile]\n\nOptions:\n  -O <password>                            : Set the owner password (ignored if cert is set)\n  -U <password>                            : Set the user password (ignored if cert is set)\n  -certFile <path to cert>                 : Path to X.509 certificate\n  -canAssemble <true|false>                : Set the assemble permission\n  -canExtractContent <true|false>          : Set the extraction permission\n  -canExtractForAccessibility <true|false> : Set the extraction permission\n  -canFillInForm <true|false>              : Set the fill in form permission\n  -canModify <true|false>                  : Set the modify permission\n  -canModifyAnnotations <true|false>       : Set the modify annots permission\n  -canPrint <true|false>                   : Set the print permission\n  -canPrintDegraded <true|false>           : Set the print degraded permission\n  -keyLength <length>                      : The length of the key in bits (valid values: 40, 128 or 256, default is 40)\n\nNote: By default all permissions are set to true!";
        System.err.println(message);
        System.exit(1);
    }
}

