/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.chart.AxisOrientation;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSlide;

public class BarChartDemo {
    private static void usage() {
        System.out.println("Usage: BarChartDemo <bar-chart-template.pptx> <bar-chart-data.txt>");
        System.out.println("    bar-chart-template.pptx     template with a bar chart");
        System.out.println("    bar-chart-data.txt          the model to set. First line is chart title, then go pairs {axis-label value}");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            BarChartDemo.usage();
            return;
        }
        try (FileInputStream argIS = new FileInputStream(args[0]);
             BufferedReader modelReader = new BufferedReader(new FileReader(args[1]));){
            String ln;
            String chartTitle = modelReader.readLine();
            String[] series = modelReader.readLine().split(",");
            ArrayList<String> listLanguages = new ArrayList<String>(10);
            ArrayList<Double> listCountries = new ArrayList<Double>(10);
            ArrayList<Double> listSpeakers = new ArrayList<Double>(10);
            while ((ln = modelReader.readLine()) != null) {
                String[] vals = ln.split(",");
                listCountries.add(Double.valueOf(vals[0]));
                listSpeakers.add(Double.valueOf(vals[1]));
                listLanguages.add(vals[2]);
            }
            String[] categories = listLanguages.toArray(new String[listLanguages.size()]);
            Double[] values1 = listCountries.toArray(new Double[listCountries.size()]);
            Double[] values2 = listSpeakers.toArray(new Double[listSpeakers.size()]);
            try (XMLSlideShow pptx = new XMLSlideShow((InputStream)argIS);){
                XSLFSlide slide = (XSLFSlide)pptx.getSlides().get(0);
                BarChartDemo.setBarData(BarChartDemo.findChart(slide), chartTitle, series, categories, values1, values2);
                XSLFChart chart = BarChartDemo.findChart(pptx.createSlide().importContent((XSLFSheet)slide));
                BarChartDemo.setColumnData(chart, "Column variant");
                try (FileOutputStream out = new FileOutputStream("bar-chart-demo-output.pptx");){
                    pptx.write((OutputStream)out);
                }
            }
        }
    }

    private static void setBarData(XSLFChart chart, String chartTitle, String[] series, String[] categories, Double[] values1, Double[] values2) {
        List data = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)data.get(0);
        int numOfPoints = categories.length;
        String categoryDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 0, 0));
        String valuesDataRange = chart.formatRange(new CellRangeAddress(1, numOfPoints, 1, 1));
        String valuesDataRange2 = chart.formatRange(new CellRangeAddress(1, numOfPoints, 2, 2));
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
        XDDFNumericalDataSource valuesData = XDDFDataSourcesFactory.fromArray((Number[])values1, (String)valuesDataRange, (int)1);
        values1[6] = 16.0;
        XDDFNumericalDataSource valuesData2 = XDDFDataSourcesFactory.fromArray((Number[])values2, (String)valuesDataRange2, (int)2);
        XDDFChartData.Series series1 = bar.getSeries(0);
        series1.replaceData((XDDFDataSource)categoriesData, valuesData);
        series1.setTitle(series[0], chart.setSheetTitle(series[0], 0));
        XDDFChartData.Series series2 = bar.addSeries((XDDFDataSource)categoriesData, valuesData2);
        series2.setTitle(series[1], chart.setSheetTitle(series[1], 1));
        chart.plot((XDDFChartData)bar);
        chart.setTitleText(chartTitle);
    }

    private static void setColumnData(XSLFChart chart, String chartTitle) {
        List series = chart.getChartSeries();
        XDDFBarChartData bar = (XDDFBarChartData)series.get(0);
        bar.setBarDirection(BarDirection.COL);
        bar.getCategoryAxis().setOrientation(AxisOrientation.MAX_MIN);
        ((XDDFValueAxis)bar.getValueAxes().get(0)).setPosition(AxisPosition.TOP);
    }

    private static XSLFChart findChart(XSLFSlide slide) {
        XSLFChart chart = null;
        for (POIXMLDocumentPart part : slide.getRelations()) {
            if (!(part instanceof XSLFChart)) continue;
            chart = (XSLFChart)part;
            break;
        }
        if (chart == null) {
            throw new IllegalStateException("chart not found in the template");
        }
        return chart;
    }
}

