/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.mapper.model;

import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;

public class FieldDescriptor {
    private String fieldName;
    private String fieldType;
    private Class fieldTypeClass;
    private String jcrName;
    private String jcrType;
    private boolean jcrAutoCreated;
    private boolean jcrMandatory;
    private String jcrOnParentVersion;
    private boolean jcrProtected;
    private boolean jcrMultiple;
    private ClassDescriptor classDescriptor;
    private boolean id;
    private boolean path;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public Class getFieldTypeClass() {
        if (this.fieldType == null) {
            return null;
        }
        if (this.fieldTypeClass == null) {
            this.fieldTypeClass = this.loadFieldTypeClass();
        }
        return this.fieldTypeClass;
    }

    public String getJcrName() {
        return this.jcrName;
    }

    public void setJcrName(String jcrName) {
        this.jcrName = jcrName;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public void setClassDescriptor(ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isPath() {
        return this.path;
    }

    public void setPath(boolean path) {
        this.path = path;
    }

    public String getJcrType() {
        return this.jcrType;
    }

    public void setJcrType(String value) {
        this.jcrType = value;
    }

    public boolean isJcrAutoCreated() {
        return this.jcrAutoCreated;
    }

    public void setJcrAutoCreated(boolean value) {
        this.jcrAutoCreated = value;
    }

    public boolean isJcrMandatory() {
        return this.jcrMandatory;
    }

    public void setJcrMandatory(boolean value) {
        this.jcrMandatory = value;
    }

    public String getJcrOnParentVersion() {
        return this.jcrOnParentVersion;
    }

    public void setJcrOnParentVersion(String value) {
        this.jcrOnParentVersion = value;
    }

    public boolean isJcrProtected() {
        return this.jcrProtected;
    }

    public void setJcrProtected(boolean value) {
        this.jcrProtected = value;
    }

    public boolean isJcrMultiple() {
        return this.jcrMultiple;
    }

    public void setJcrMultiple(boolean value) {
        this.jcrMultiple = value;
    }

    private Class loadFieldTypeClass() {
        if (this.fieldType == null) {
            return null;
        }
        if ("byte".equals(this.fieldType)) {
            return Byte.TYPE;
        }
        if ("short".equals(this.fieldType)) {
            return Short.TYPE;
        }
        if ("int".equals(this.fieldType)) {
            return Integer.TYPE;
        }
        if ("long".equals(this.fieldType)) {
            return Long.TYPE;
        }
        if ("float".equals(this.fieldType)) {
            return Float.TYPE;
        }
        if ("double".equals(this.fieldType)) {
            return Double.TYPE;
        }
        if ("char".equals(this.fieldType)) {
            return Character.TYPE;
        }
        if ("boolean".equals(this.fieldType)) {
            return Boolean.TYPE;
        }
        try {
            return Class.forName(this.fieldType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public String toString() {
        return "Field Descriptor : " + this.getFieldName();
    }
}

