/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.collectionconverter;

import java.util.Collection;
import java.util.Set;
import java.util.Vector;
import org.apache.portals.graffito.jcr.exception.JcrMappingException;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollection;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.ManageableArrayList;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.ManageableSet;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.ManageableVector;

public class ManageableCollectionUtil {
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public static ManageableCollection getManageableCollection(String manageableCollectionClassName) {
        try {
            Class<?> collectionClass = Class.forName(manageableCollectionClassName);
            return (ManageableCollection)collectionClass.newInstance();
        }
        catch (Exception e) {
            throw new JcrMappingException("Cannot create manageable collection : " + manageableCollectionClassName, e);
        }
    }

    public static ManageableCollection getManageableCollection(Class collectionClass) {
        try {
            if (collectionClass.equals(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ManageableCollectionUtil.class$("java.util.ArrayList")) : class$java$util$ArrayList)) {
                return new ManageableArrayList();
            }
            if (collectionClass.equals(class$java$util$Vector == null ? (class$java$util$Vector = ManageableCollectionUtil.class$("java.util.Vector")) : class$java$util$Vector)) {
                return new ManageableVector();
            }
            if (collectionClass.equals(class$java$util$HashSet == null ? (class$java$util$HashSet = ManageableCollectionUtil.class$("java.util.HashSet")) : class$java$util$HashSet)) {
                return new ManageableSet();
            }
            if (collectionClass.equals(class$java$util$Collection == null ? (class$java$util$Collection = ManageableCollectionUtil.class$("java.util.Collection")) : class$java$util$Collection) || collectionClass.equals(class$java$util$List == null ? (class$java$util$List = ManageableCollectionUtil.class$("java.util.List")) : class$java$util$List)) {
                return new ManageableArrayList();
            }
            if (collectionClass.equals(class$java$util$Set == null ? (class$java$util$Set = ManageableCollectionUtil.class$("java.util.Set")) : class$java$util$Set)) {
                return new ManageableSet();
            }
            Object collection = collectionClass.newInstance();
            if (!(collection instanceof ManageableCollection)) {
                throw new JcrMappingException("Unsupported collection type :" + collectionClass.getName());
            }
            return (ManageableCollection)collection;
        }
        catch (Exception e) {
            throw new JcrMappingException("Cannot create manageable collection", e);
        }
    }

    public static ManageableCollection getManageableCollection(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (object instanceof ManageableCollection) {
                return (ManageableCollection)object;
            }
            if (object instanceof Vector) {
                ManageableVector manageableVector = new ManageableVector();
                manageableVector.addAll((Collection)object);
                return manageableVector;
            }
            if (object instanceof Set) {
                return new ManageableSet((Collection)((Set)object));
            }
            if (object instanceof Collection) {
                ManageableArrayList manageableArrayList = new ManageableArrayList();
                manageableArrayList.addAll((Collection)object);
                return manageableArrayList;
            }
        }
        catch (Exception e) {
            throw new JcrMappingException("Impossible to create the manageable collection", e);
        }
        throw new JcrMappingException("Unsupported collection type :" + object.getClass().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

