/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.graffito.jcr.persistence.collectionconverter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.graffito.jcr.mapper.Mapper;
import org.apache.portals.graffito.jcr.mapper.model.ClassDescriptor;
import org.apache.portals.graffito.jcr.mapper.model.CollectionDescriptor;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollection;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.ManageableCollectionUtil;
import org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.AbstractCollectionConverterImpl;
import org.apache.portals.graffito.jcr.persistence.objectconverter.ObjectConverter;
import org.apache.portals.graffito.jcr.reflection.ReflectionUtils;

public class NTCollectionConverterImpl
extends AbstractCollectionConverterImpl {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$portals$graffito$jcr$persistence$collectionconverter$impl$NTCollectionConverterImpl == null ? (class$org$apache$portals$graffito$jcr$persistence$collectionconverter$impl$NTCollectionConverterImpl = NTCollectionConverterImpl.class$("org.apache.portals.graffito.jcr.persistence.collectionconverter.impl.NTCollectionConverterImpl")) : class$org$apache$portals$graffito$jcr$persistence$collectionconverter$impl$NTCollectionConverterImpl));
    private static final String COLLECTION_ELEMENT_NAME = "collection-element";
    static /* synthetic */ Class class$org$apache$portals$graffito$jcr$persistence$collectionconverter$impl$NTCollectionConverterImpl;

    public NTCollectionConverterImpl(Map atomicTypeConverters, ObjectConverter objectConverter, Mapper mapper) {
        super(atomicTypeConverters, objectConverter, mapper);
    }

    protected void doInsertCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) {
        if (collection == null) {
            return;
        }
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        Iterator collectionIterator = collection.getIterator();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
            } else {
                elementJcrName = COLLECTION_ELEMENT_NAME;
            }
            this.objectConverter.insert(session, parentNode, elementJcrName, item);
        }
    }

    protected void doUpdateCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, ManageableCollection collection) throws RepositoryException {
        Mapper mapper = collectionDescriptor.getClassDescriptor().getMappingDescriptor().getMapper();
        ClassDescriptor elementClassDescriptor = mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        if (collection == null || !elementClassDescriptor.hasIdField()) {
            this.deleteCollectionItems(session, parentNode, elementClassDescriptor.getJcrNodeType());
        }
        if (collection == null) {
            return;
        }
        Iterator collectionIterator = collection.getIterator();
        HashMap updatedItems = new HashMap();
        while (collectionIterator.hasNext()) {
            Object item = collectionIterator.next();
            String elementJcrName = null;
            if (elementClassDescriptor.hasIdField()) {
                String idFieldName = elementClassDescriptor.getIdFieldDescriptor().getFieldName();
                elementJcrName = ReflectionUtils.getNestedProperty(item, idFieldName).toString();
                if (parentNode.hasNode(elementJcrName)) {
                    this.objectConverter.update(session, parentNode, elementJcrName, item);
                } else {
                    this.objectConverter.insert(session, parentNode, elementJcrName, item);
                }
                updatedItems.put(elementJcrName, item);
                continue;
            }
            elementJcrName = COLLECTION_ELEMENT_NAME;
            this.objectConverter.insert(session, parentNode, elementJcrName, item);
        }
        if (elementClassDescriptor.hasIdField()) {
            Iterator nodeIterator = this.getCollectionNodes(session, parentNode, elementClassDescriptor.getJcrNodeType()).iterator();
            while (nodeIterator.hasNext()) {
                Node child = (Node)nodeIterator.next();
                if (updatedItems.containsKey(child.getName())) continue;
                child.remove();
            }
        }
    }

    protected ManageableCollection doGetCollection(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        ClassDescriptor elementClassDescriptor = this.mapper.getClassDescriptorByClass(ReflectionUtils.forName(collectionDescriptor.getElementClassName()));
        ManageableCollection collection = ManageableCollectionUtil.getManageableCollection(collectionFieldClass);
        Class elementClass = ReflectionUtils.forName(collectionDescriptor.getElementClassName());
        Iterator children = this.getCollectionNodes(session, parentNode, elementClassDescriptor.getJcrNodeType()).iterator();
        while (children.hasNext()) {
            Node itemNode = (Node)children.next();
            log.debug((Object)("Collection node found : " + itemNode.getPath()));
            Object item = this.objectConverter.getObject(session, itemNode.getPath());
            collection.addObject(item);
        }
        return collection;
    }

    protected boolean doIsNull(Session session, Node parentNode, CollectionDescriptor collectionDescriptor, Class collectionFieldClass) throws RepositoryException {
        return false;
    }

    private Collection getCollectionNodes(Session session, Node parentNode, String itemNodeType) throws PathNotFoundException, ValueFormatException, RepositoryException {
        ArrayList<Node> collectionNodes = new ArrayList<Node>();
        if (!parentNode.getPath().startsWith("/jcr:system/jcr:versionStorage")) {
            NodeIterator nodeIterator = parentNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                if (!child.isNodeType(itemNodeType)) continue;
                collectionNodes.add(child);
            }
        } else {
            NodeIterator nodeIterator = parentNode.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                if (!child.getProperty("jcr:frozenPrimaryType").getString().equals(itemNodeType)) continue;
                collectionNodes.add(child);
            }
        }
        return collectionNodes;
    }

    private void deleteCollectionItems(Session session, Node parentNode, String itemNodeType) throws VersionException, LockException, ConstraintViolationException, PathNotFoundException, ValueFormatException, RepositoryException {
        Iterator nodeIterator = this.getCollectionNodes(session, parentNode, itemNodeType).iterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            node.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

