/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletSession;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.driver.url.PortletParameterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionScopedRequestAttributeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ActionScopedRequestAttributeHandler.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final List<String> disallowedPrefixes = new ArrayList<String>();
    private static final List<String> disallowedNames = new ArrayList<String>();
    private static final String ATTRIB_NAME = "javax.portlet.asraSessionData";
    private static final Object LOCK;
    private final PortletRequestContext requestContext;
    private final PortletParameterFactory paramFactory;
    private final String phase;
    private String windowId;
    private boolean active = false;
    private boolean settable = false;
    private int numScopes = -1;
    private SessionData sessionData = null;
    private Map<String, Object> activeMap = null;
    private Integer currentIndex = null;

    public ActionScopedRequestAttributeHandler(PortletRequestContext requestContext, PortletParameterFactory paramFactory, String phase) {
        this.paramFactory = paramFactory;
        this.requestContext = requestContext;
        this.phase = phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(PortletResponseContext responseContext) {
        this.windowId = this.requestContext.getPortletWindow().getId().getStringId();
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("requestContext null: ").append(this.requestContext == null);
            if (this.requestContext != null) {
                txt.append(", portletConfig null: ").append(this.requestContext.getPortletConfig() == null);
            }
            LOG.debug(txt.toString());
        }
        Map options = this.requestContext.getPortletConfig().getContainerRuntimeOptions();
        Object[] vals = null;
        if (options != null && (vals = (String[])options.get("javax.portlet.actionScopedRequestAttributes")) != null && vals.length > 0 && Boolean.parseBoolean(vals[0])) {
            if (vals.length == 1) {
                this.numScopes = 4;
            } else if (vals.length == 3 && vals[1].equalsIgnoreCase("numberOfCachedScopes") && ((String)vals[2]).matches("\\d+")) {
                this.numScopes = Integer.parseInt((String)vals[2]);
            }
        }
        this.active = this.numScopes > 0;
        boolean bl = this.settable = this.active && (this.phase.equals("ACTION_PHASE") || this.phase.equals("EVENT_PHASE"));
        if (!this.active && vals != null) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Bad actionScopedRequestAttributes runtime option. Values: ");
            txt.append(Arrays.toString(vals));
            LOG.warn(txt.toString());
        }
        Object[] scopeId = null;
        if (this.active) {
            Object object = LOCK;
            synchronized (object) {
                PortletSession ps = this.requestContext.getPortletSession(true);
                if (this.active && ps != null) {
                    this.sessionData = (SessionData)ps.getAttribute(ATTRIB_NAME);
                    if (this.sessionData != null) {
                        this.currentIndex = this.getCurrentIndex();
                        if (this.phase.equals("RENDER_PHASE")) {
                            this.sessionData.rendered = true;
                        }
                    }
                }
                if (this.sessionData != null) {
                    if (this.currentIndex == null) {
                        this.sessionData = null;
                        this.activeMap = null;
                        ps.removeAttribute(ATTRIB_NAME);
                    } else {
                        this.activeMap = this.sessionData.attribs.get(this.currentIndex);
                    }
                }
                if (this.phase.equals("ACTION_PHASE") || this.phase.equals("EVENT_PHASE") && this.sessionData == null || this.phase.equals("EVENT_PHASE") && this.sessionData.rendered) {
                    if (this.sessionData == null) {
                        this.sessionData = new SessionData();
                        this.currentIndex = 0;
                        this.sessionData.attribs.put(this.currentIndex, new ConcurrentHashMap());
                        this.sessionData.rendered = false;
                        this.activeMap = this.sessionData.attribs.get(this.currentIndex);
                        ps.setAttribute(ATTRIB_NAME, (Object)this.sessionData);
                    } else {
                        ArrayList<Integer> activeScopes = new ArrayList<Integer>(this.sessionData.attribs.keySet());
                        Collections.sort(activeScopes);
                        int index = activeScopes.indexOf(this.currentIndex);
                        for (int ii = index + 1; ii < activeScopes.size(); ++ii) {
                            this.sessionData.attribs.remove(activeScopes.get(ii));
                        }
                        Integer n = this.currentIndex;
                        Integer n2 = this.currentIndex = Integer.valueOf(this.currentIndex + 1);
                        this.sessionData.attribs.put(this.currentIndex, new ConcurrentHashMap());
                        this.sessionData.rendered = false;
                        this.activeMap = this.sessionData.attribs.get(this.currentIndex);
                        if (this.sessionData.attribs.size() > this.numScopes) {
                            this.sessionData.attribs.remove(activeScopes.get(0));
                        }
                    }
                }
            }
            if (this.sessionData != null) {
                scopeId = new String[]{Long.toString(this.sessionData.id), this.currentIndex.toString()};
            }
            responseContext.setActionScopedId(this.windowId, scopeId);
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("isActive: ").append(this.active);
            txt.append(", isSettable: ").append(this.settable);
            txt.append(", phase: ").append(this.phase);
            txt.append(", rendered: ").append(this.sessionData == null ? "n/a" : Boolean.valueOf(this.sessionData.rendered));
            txt.append(", session data: ").append(this.sessionData != null ? "not null" : "null");
            txt.append(", scope id: ").append(scopeId == null ? "null" : Arrays.toString(scopeId));
            txt.append(", current index: ").append(this.currentIndex);
            txt.append(", option values: ").append(vals == null ? "null" : Arrays.toString(vals));
            LOG.debug(txt.toString());
        }
    }

    private Integer getCurrentIndex() {
        Long id = null;
        Integer index = null;
        String type = "rp";
        if (this.phase.equals("RESOURCE_PHASE")) {
            type = "re";
        }
        Map params = this.paramFactory.getParameterMap(this.windowId, type);
        Object[] asvals = (String[])params.get("javax.portlet.as");
        if (this.sessionData != null && asvals != null && asvals.length == 2) {
            try {
                id = new Long(asvals[0]);
                index = new Integer(asvals[1]);
                if (id != this.sessionData.id || !this.sessionData.attribs.containsKey(index)) {
                    index = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("isActive: ").append(this.active);
            txt.append(", session data exists: ").append(this.sessionData != null);
            txt.append(", request id: ").append(id);
            txt.append(", scope id: ").append(this.sessionData == null ? "null" : Long.valueOf(this.sessionData.id));
            txt.append(", index: ").append(index);
            txt.append(", action scope param values: ").append(asvals == null ? "null" : Arrays.toString(asvals));
            LOG.debug(txt.toString());
        }
        return index;
    }

    private boolean isNameOk(String name) {
        boolean isOk = true;
        for (String prefix : disallowedPrefixes) {
            if (!name.startsWith(prefix)) continue;
            isOk = false;
            break;
        }
        if (disallowedNames.contains(name)) {
            isOk = false;
        }
        return isOk;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSettable() {
        return this.settable;
    }

    public Object getAttribute(String name) {
        Object value = null;
        if (this.active && name != null && this.activeMap != null) {
            value = this.activeMap.get(name);
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Name: ").append(name);
            txt.append(", value is null: ").append(value == null);
            txt.append(", index: ").append(this.currentIndex);
            txt.append(", active: ").append(this.active);
            txt.append(", active map is null: ").append(this.activeMap == null);
            LOG.debug(txt.toString());
        }
        return value;
    }

    public void removeAttribute(String name) {
        if (this.active && this.activeMap != null) {
            this.activeMap.remove(name);
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Name: ").append(name);
            txt.append(", index: ").append(this.currentIndex);
            txt.append(", active: ").append(this.active);
            txt.append(", active map is null: ").append(this.activeMap == null);
            LOG.debug(txt.toString());
        }
    }

    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.active && this.activeMap != null) {
            names.addAll(this.activeMap.keySet());
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Attribute names: ").append(((Object)names).toString());
            txt.append(", index: ").append(this.currentIndex);
            txt.append(", active: ").append(this.active);
            txt.append(", active map is null: ").append(this.activeMap == null);
            LOG.debug(txt.toString());
        }
        return names;
    }

    public boolean setAttribute(String name, Object value) {
        boolean attribSet = false;
        if (this.settable && this.isNameOk(name) && this.activeMap != null) {
            this.activeMap.put(name, value);
            attribSet = true;
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Attribute name: ").append(name);
            txt.append(", value is null: ").append(value == null);
            txt.append(", attribSet: ").append(attribSet);
            txt.append(", index: ").append(this.currentIndex);
            txt.append(", settable: ").append(this.settable);
            txt.append(", active map is null: ").append(this.activeMap == null);
            LOG.debug(txt.toString());
        }
        return attribSet;
    }

    static {
        ResourceBundle configBundle = null;
        try {
            configBundle = ResourceBundle.getBundle("org.apache.pluto.driver.services.container.ActionScopedRequestAttributeHandler");
        }
        catch (Throwable t) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Exception getting configuration file: \n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.flush();
            txt.append(sw.toString());
            LOG.warn(txt.toString());
        }
        if (configBundle != null) {
            String val = configBundle.getString("prefixes");
            if (val != null) {
                disallowedPrefixes.addAll(Arrays.asList(val.split(";")));
            }
            if ((val = configBundle.getString("names")) != null) {
                disallowedNames.addAll(Arrays.asList(val.split(";")));
            }
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Bundle could be read: ").append(configBundle != null);
            txt.append(", disallowed prefixes: ").append(disallowedPrefixes.toString());
            txt.append(", disallowed names: ").append(disallowedNames.toString());
            LOG.debug(txt.toString());
        }
        LOCK = new Object();
    }

    private static class SessionData
    implements Serializable {
        private static final long serialVersionUID = 7680043718084556191L;
        public Map<Integer, Map<String, Object>> attribs = new HashMap<Integer, Map<String, Object>>();
        public boolean rendered = false;
        public final long id = new Random().nextLong();
    }
}

