/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.pluto.container.EventProvider;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.EventDefinition;
import org.apache.pluto.container.om.portlet.EventDefinitionReference;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.driver.services.container.EventImpl;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProviderImpl
implements EventProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EventProviderImpl.class);
    private PortletWindow portletWindow;
    private PortletRegistryService portletRegistry;

    public EventProviderImpl(PortletWindow portletWindow, PortletRegistryService portletRegistry) {
        this.portletWindow = portletWindow;
        this.portletRegistry = portletRegistry;
        if (LOG.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Portlet window: ").append(portletWindow.getId().getStringId());
            LOG.debug(txt.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event createEvent(QName qname, Serializable value) throws IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("QName: ").append(qname.toString());
            txt.append(", value class: ").append(value == null ? "null" : value.getClass().getCanonicalName());
            LOG.debug(txt.toString());
        }
        if (this.isDeclaredAsPublishingEvent(qname)) {
            if (value != null && !this.isValueInstanceOfDefinedClass(qname, value)) {
                throw new IllegalArgumentException("Payload class (" + value.getClass().getCanonicalName() + ") does not have the right class, check your defined event types in portlet.xml.");
            }
            try {
                if (value == null) {
                    return new EventImpl(qname, value);
                }
                boolean debug = false;
                if (LOG.isDebugEnabled() && value instanceof HashMap) {
                    debug = true;
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Event payload params:");
                    HashMap pmap = (HashMap)value;
                    for (String name : pmap.keySet()) {
                        txt.append("\nname: ").append(name);
                        txt.append(", vals: ").append(Arrays.toString((Object[])pmap.get(name)));
                    }
                    LOG.debug(txt.toString());
                }
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                StringWriter out = new StringWriter();
                Class<?> clazz = value.getClass();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
                    Marshaller marshaller = jc.createMarshaller();
                    JAXBElement element = new JAXBElement(qname, clazz, (Object)value);
                    marshaller.marshal((Object)element, (Writer)out);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                if (debug) {
                    LOG.debug("Resulting marshalled HashMap: \n" + ((Object)out).toString());
                }
                return new EventImpl(qname, (Serializable)((Object)((Object)out).toString()));
            }
            catch (JAXBException e) {
                LOG.error("Event handling failed", (Throwable)e);
            }
            catch (FactoryConfigurationError e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private boolean isDeclaredAsPublishingEvent(QName qname) {
        String applicationId;
        String applicationName = applicationId = PortletWindowConfig.parseContextPath((String)this.portletWindow.getId().getStringId());
        String portletName = PortletWindowConfig.parsePortletName((String)this.portletWindow.getId().getStringId());
        List events = null;
        try {
            events = this.portletRegistry.getPortlet(applicationName, portletName).getSupportedPublishingEvents();
        }
        catch (PortletContainerException e1) {
            e1.printStackTrace();
        }
        if (events != null) {
            for (EventDefinitionReference ref : events) {
                QName name = ref.getQualifiedName();
                if (name == null || !qname.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isValueInstanceOfDefinedClass(QName qname, Serializable value) {
        PortletApplicationDefinition app = this.portletWindow.getPortletDefinition().getApplication();
        List events = app.getEventDefinitions();
        if (events != null) {
            for (EventDefinition def : events) {
                if (!def.getQName().equals(qname)) continue;
                Class<?> declaredPayload = null;
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        cl = this.getClass().getClassLoader();
                    }
                    if (!(declaredPayload = cl.loadClass(def.getValueType())).isAssignableFrom(value.getClass())) {
                        StringBuilder txt = new StringBuilder(128);
                        txt.append("Error processing payload. ");
                        txt.append(" Specified class ").append(value.getClass().getCanonicalName());
                        txt.append(" is not a ").append(declaredPayload.getCanonicalName());
                        LOG.warn(txt.toString());
                        return false;
                    }
                }
                catch (Exception e) {
                    StringBuilder txt = new StringBuilder(128);
                    txt.append("Error processing payload. ");
                    txt.append(" Exception: ").append(e.toString());
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    txt.append("\n").append(sw.toString());
                    LOG.warn(txt.toString());
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

