/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.portlet.PortalContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.pluto.driver.config.DriverConfiguration;

public class PortalContextImpl
implements PortalContext {
    private DriverConfiguration config;
    private String info = null;
    private HashMap<String, String> properties = new HashMap();
    private Vector<PortletMode> portletModes;
    private Vector<WindowState> windowStates;

    public PortalContextImpl(DriverConfiguration config) {
        this.config = config;
        this.reset();
        this.properties.put("javax.portlet.markup.head.element.support", "true");
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        return this.properties.get(name);
    }

    public Enumeration<String> getPropertyNames() {
        Vector<String> names = new Vector<String>(this.properties.keySet());
        return names.elements();
    }

    public Enumeration<PortletMode> getSupportedPortletModes() {
        if (this.portletModes == null) {
            this.portletModes = new Vector();
            Enumeration enumeration = new Vector(this.config.getSupportedPortletModes()).elements();
            while (enumeration.hasMoreElements()) {
                this.portletModes.add(new PortletMode(enumeration.nextElement().toString()));
            }
        }
        return this.portletModes.elements();
    }

    public Enumeration<WindowState> getSupportedWindowStates() {
        if (this.windowStates == null) {
            this.windowStates = new Vector();
            Enumeration enumeration = new Vector(this.config.getSupportedWindowStates()).elements();
            while (enumeration.hasMoreElements()) {
                this.windowStates.add(new WindowState(enumeration.nextElement().toString()));
            }
        }
        return this.windowStates.elements();
    }

    public String getPortalInfo() {
        if (this.info == null) {
            this.info = this.config.getPortalName() + "/" + this.config.getPortalVersion();
        }
        return this.info;
    }

    public void setProperty(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Property name == null");
        }
        this.properties.put(name, value);
    }

    public void reset() {
        this.info = null;
        this.properties.clear();
    }

    public DriverConfiguration getDriverConfiguration() {
        return this.config;
    }
}

