/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletAsyncListener;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletAsyncManager;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.bean.processor.PortletArtifactProducer;
import org.apache.pluto.container.bean.processor.PortletRequestScopedBeanHolder;
import org.apache.pluto.container.bean.processor.PortletSessionBeanHolder;
import org.apache.pluto.container.bean.processor.PortletStateScopedBeanHolder;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.driver.services.container.PortletAsyncContextListener;
import org.apache.pluto.driver.services.container.PortletAsyncContextualRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletAsyncContextImpl
implements PortletAsyncManager,
AsyncContext,
PortletAsyncContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletAsyncContextImpl.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private AsyncContext actx;
    private final HttpServletRequest hreq;
    private final PortletAsyncContextListener pal;
    private final PortletResourceRequestContext prctx;
    private ResourceRequest resreq;
    private ResourceResponse resresp;
    private boolean hasOriginalReqResp = true;
    private PortletSessionBeanHolder sessbh;
    private PortletStateScopedBeanHolder statebh;
    private PortletRequestScopedBeanHolder reqbh;
    private BeanManager beanmgr;
    private Runnable pendingRunner;
    private boolean doDeregister = true;
    private boolean complete = false;
    private boolean isContextActive = true;
    private boolean isDispatchedOrComplete = false;

    public PortletAsyncContextImpl(AsyncContext actx, PortletResourceRequestContext prctx, ResourceRequest resreq, ResourceResponse resresp, boolean origReqResp) {
        this.actx = actx;
        this.prctx = prctx;
        this.resreq = resreq;
        this.resresp = resresp;
        this.hasOriginalReqResp = origReqResp;
        this.hreq = (HttpServletRequest)actx.getRequest();
        this.beanmgr = prctx.getBeanManager();
        HttpServletRequest creq = prctx.getContainerRequest();
        HttpServletResponse cresp = prctx.getContainerResponse();
        this.pal = new PortletAsyncContextListener(this);
        actx.addListener((AsyncListener)this.pal, (ServletRequest)creq, (ServletResponse)cresp);
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void registerContext(boolean isListener) {
        if (this.complete || isListener && PortletRequestScopedBeanHolder.getBeanHolder() != null) {
            this.doDeregister = false;
        } else {
            this.doDeregister = true;
            PortletSessionBeanHolder.register((PortletSessionBeanHolder)this.sessbh);
            PortletStateScopedBeanHolder.register((PortletStateScopedBeanHolder)this.statebh);
            PortletRequestScopedBeanHolder.register((PortletRequestScopedBeanHolder)this.reqbh);
            PortletArtifactProducer.setPrecursors((PortletRequest)this.resreq, (PortletResponse)this.prctx.getResponse(), (PortletConfig)this.prctx.getPortletConfig());
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Registered context.");
            txt.append(" complete: ").append(this.complete);
            txt.append(", isListener: ").append(isListener);
            txt.append(", doRegister: ").append(this.doDeregister);
            LOG.trace(txt.toString());
        }
    }

    public void deregisterContext(boolean isListener) {
        if (!(this.complete || isListener && !this.doDeregister)) {
            this.sessbh = PortletSessionBeanHolder.deregister();
            this.statebh = PortletStateScopedBeanHolder.deregister();
            this.reqbh = PortletRequestScopedBeanHolder.deregister();
            PortletArtifactProducer.remove();
        }
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Deregistered context.");
            txt.append(" complete: ").append(this.complete);
            txt.append(", isListener: ").append(isListener);
            txt.append(", doRegister: ").append(this.doDeregister);
            LOG.trace(txt.toString());
        }
    }

    public void launchRunner() {
        if (this.pendingRunner != null) {
            PortletAsyncContextualRunner runner = new PortletAsyncContextualRunner();
            if (isTrace) {
                StringBuilder txt = new StringBuilder();
                txt.append("Executing Portlet Runnable: " + this.pendingRunner.getClass().getCanonicalName());
                LOG.trace(txt.toString());
            }
            runner.init(this, this.pendingRunner);
            this.pendingRunner = null;
            this.actx.start((Runnable)runner);
        }
    }

    public HttpServletRequestWrapper getAsyncRequestWrapper() {
        HttpServletPortletRequestWrapper wrapper = null;
        HttpServletRequest wreq = this.prctx.getAsyncServletRequest();
        while (wreq instanceof ServletRequestWrapper && !(wreq instanceof HttpServletPortletRequestWrapper)) {
            wreq = ((ServletRequestWrapper)wreq).getRequest();
        }
        if (wreq instanceof HttpServletPortletRequestWrapper) {
            wrapper = (HttpServletPortletRequestWrapper)wreq;
        }
        return wrapper;
    }

    public void removeContext() {
        PortletSessionBeanHolder.removeBeanHolder();
        PortletStateScopedBeanHolder.removeBeanHolder(null);
        PortletRequestScopedBeanHolder.removeBeanHolder();
        PortletArtifactProducer.remove();
    }

    public void setWrapped(AsyncContext actx) {
        this.actx = actx;
        this.isContextActive = true;
        this.isDispatchedOrComplete = false;
    }

    public void addListener(AsyncListener l) {
        if (!this.isContextActive) {
            throw new IllegalStateException("Listener can only be added when the asynchronous context is active.");
        }
        this.pal.addListener(l);
    }

    public void addListener(AsyncListener l, ServletRequest req, ServletResponse resp) {
        if (!this.isContextActive) {
            throw new IllegalStateException("Listener can only be added when the asynchronous context is active.");
        }
        this.pal.addListener(l, req, resp);
    }

    public void complete() {
        this.isDispatchedOrComplete = true;
        this.actx.complete();
    }

    public <T extends AsyncListener> T createListener(Class<T> cls) throws ServletException {
        AsyncListener obj = null;
        try {
            obj = (AsyncListener)this.createInstance(cls);
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
        return (T)obj;
    }

    public void dispatch() {
        this.isDispatchedOrComplete = true;
        this.actx.dispatch(this.hreq.getServletContext(), this.hreq.getServletPath());
    }

    public void dispatch(String path) {
        this.isDispatchedOrComplete = true;
        HttpServletPortletRequestWrapper wrapper = (HttpServletPortletRequestWrapper)this.getAsyncRequestWrapper();
        wrapper.startAsyncDispatch(path);
        this.actx.dispatch(this.hreq.getServletContext(), path);
    }

    public void dispatch(ServletContext sctx, String path) {
        this.isDispatchedOrComplete = true;
        this.actx.dispatch(sctx, path);
    }

    public ServletRequest getRequest() {
        return this.actx.getRequest();
    }

    public ServletResponse getResponse() {
        return this.actx.getResponse();
    }

    public long getTimeout() {
        return this.actx.getTimeout();
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.hasOriginalReqResp;
    }

    public void setTimeout(long time) {
        this.actx.setTimeout(time);
    }

    public void start(Runnable run) {
        if (!this.isContextActive) {
            throw new IllegalStateException("Asynchronous thread can only be started when the asynchronous context is active.");
        }
        if (this.isDispatchedOrComplete) {
            throw new IllegalStateException("Asynchronous thread cannot be started after an asynchronous dispatch has been performed or asynchronous processing has been completed.");
        }
        this.pendingRunner = run;
    }

    public void addListener(PortletAsyncListener listener) throws IllegalStateException {
        if (!this.isContextActive) {
            throw new IllegalStateException("Listener can only be added when the asynchronous context is active.");
        }
        this.pal.addListener(listener);
    }

    public void addListener(PortletAsyncListener listener, ResourceRequest request, ResourceResponse response) throws IllegalStateException {
        if (!this.isContextActive) {
            throw new IllegalStateException("Listener can only be added when the asynchronous context is active.");
        }
        this.pal.addListener(listener, request, response);
    }

    public <T extends PortletAsyncListener> T createPortletAsyncListener(Class<T> cls) throws PortletException {
        PortletAsyncListener obj;
        try {
            obj = (PortletAsyncListener)this.createInstance(cls);
        }
        catch (Throwable t) {
            throw new PortletException(t);
        }
        return (T)obj;
    }

    public ResourceRequest getResourceRequest() throws IllegalStateException {
        return this.resreq;
    }

    public ResourceResponse getResourceResponse() throws IllegalStateException {
        return this.resresp;
    }

    public void setContextInactive() {
        this.isContextActive = false;
    }

    private Object createInstance(Class<?> cls) throws IllegalAccessException, InstantiationException {
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Creating listener.");
            txt.append(" Bean manager: ").append(this.beanmgr);
            txt.append(", listener class: ").append(cls.getCanonicalName());
            LOG.trace(txt.toString());
        }
        Object lis = null;
        if (this.beanmgr != null) {
            Set beans = this.beanmgr.getBeans(cls, new Annotation[0]);
            Bean bean = this.beanmgr.resolve(beans);
            if (bean != null) {
                lis = this.beanmgr.getReference(bean, (Type)bean.getBeanClass(), this.beanmgr.createCreationalContext((Contextual)bean));
            } else {
                LOG.warn("Could not get bean reference for: " + cls.getCanonicalName());
            }
        }
        if (lis == null) {
            LOG.trace("Instantiating class directly: " + cls.getCanonicalName());
            lis = cls.newInstance();
        }
        return lis;
    }
}

