/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletMimeResponseContext;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.util.PrintWriterServletOutputStream;
import org.apache.pluto.driver.services.container.PortletResponseContextImpl;

public abstract class PortletMimeResponseContextImpl
extends PortletResponseContextImpl
implements PortletMimeResponseContext {
    private CacheControl cacheControl;
    private OutputStream outputStream;

    public PortletMimeResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, PortletRequestContext requestContext) {
        super(container, containerRequest, containerResponse, window, requestContext);
    }

    @Override
    public void close() {
        this.cacheControl = null;
        this.outputStream = null;
        super.close();
    }

    public void flushBuffer() throws IOException {
        if (!this.isClosed() && !this.isHeaderBufferActive()) {
            this.getServletResponse().flushBuffer();
        }
    }

    public int getBufferSize() {
        if (this.isHeaderBufferActive()) {
            return this.headerData.getBufferSize();
        }
        return this.getServletResponse().getBufferSize();
    }

    public CacheControl getCacheControl() {
        if (this.isClosed()) {
            return null;
        }
        if (this.cacheControl == null) {
            this.cacheControl = new CacheControlImpl();
        }
        return this.cacheControl;
    }

    public String getCharacterEncoding() {
        return this.isClosed() ? null : this.getServletResponse().getCharacterEncoding();
    }

    public String getContentType() {
        String type = null;
        if (!this.isClosed()) {
            type = this.getServletResponse().getContentType();
            if (type == null) {
                if (!this.getLifecycle().equals("RESOURCE_PHASE")) {
                    type = "text/html";
                }
            } else {
                type = type.replaceAll("([^;]*).*", "$1");
            }
        }
        return type;
    }

    public Locale getLocale() {
        return this.isClosed() ? null : this.getServletResponse().getLocale();
    }

    public OutputStream getOutputStream() throws IOException, IllegalStateException {
        if (this.isClosed()) {
            return null;
        }
        if (this.isHeaderBufferActive()) {
            return this.headerData.getBaoStream();
        }
        if (this.outputStream == null) {
            try {
                this.outputStream = this.getServletResponse().getOutputStream();
            }
            catch (IllegalStateException e) {
                this.outputStream = new PrintWriterServletOutputStream(this.getServletResponse().getWriter(), this.getServletResponse().getCharacterEncoding());
            }
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException, IllegalStateException {
        if (this.isClosed()) {
            return null;
        }
        if (this.isHeaderBufferActive()) {
            return this.headerData.getWriter();
        }
        return this.getServletResponse().getWriter();
    }

    public boolean isCommitted() {
        if (this.isHeaderBufferActive()) {
            return false;
        }
        return this.getServletResponse().isCommitted();
    }

    public void reset() {
        if (!this.isClosed()) {
            if (this.isHeaderBufferActive()) {
                this.headerData.reset();
            } else {
                this.getServletResponse().reset();
            }
        }
    }

    public void resetBuffer() {
        if (!this.isClosed()) {
            if (this.isHeaderBufferActive()) {
                this.headerData.resetBuffer();
            } else {
                this.getServletResponse().resetBuffer();
            }
        }
    }

    public void setBufferSize(int size) {
        if (!this.isClosed()) {
            if (this.isHeaderBufferActive()) {
                this.headerData.setBufferSize(size);
            } else {
                this.getServletResponse().setBufferSize(size);
            }
        }
    }

    public void setContentType(String contentType) {
        if (!this.isClosed()) {
            if (this.getLifecycle().equals("RESOURCE_PHASE")) {
                this.getServletResponse().setContentType(contentType);
            } else {
                String type = this.getServletResponse().getContentType();
                type = type == null ? "text/html" : type.replaceAll("([^;]*).*", "$1");
                if (!type.equals(contentType) && !contentType.matches("\\s*(?:\\*|\\*/\\s*\\*)\\s*")) {
                    throw new IllegalArgumentException("Invalid content type: " + contentType);
                }
            }
        }
    }

    private static class CacheControlImpl
    implements CacheControl {
        private String eTag;
        private int expirationTime;
        private boolean publicScope;
        private boolean cachedContent;

        public boolean useCachedContent() {
            return this.cachedContent;
        }

        public String getETag() {
            return this.eTag;
        }

        public int getExpirationTime() {
            return this.expirationTime;
        }

        public boolean isPublicScope() {
            return this.publicScope;
        }

        public void setETag(String eTag) {
            this.eTag = eTag;
        }

        public void setExpirationTime(int expirationTime) {
            this.expirationTime = expirationTime;
        }

        public void setPublicScope(boolean publicScope) {
            this.publicScope = publicScope;
        }

        public void setUseCachedContent(boolean cachedContent) {
            this.cachedContent = cachedContent;
        }
    }
}

