/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.ActionParameters;
import javax.portlet.PortletConfig;
import javax.portlet.PortletSession;
import javax.portlet.RenderParameters;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.ContainerServices;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletEnvironmentService;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.ActionParametersImpl;
import org.apache.pluto.container.impl.MutableActionParametersImpl;
import org.apache.pluto.container.impl.MutableRenderParametersImpl;
import org.apache.pluto.container.impl.MutableResourceParametersImpl;
import org.apache.pluto.container.impl.PortletRequestImpl;
import org.apache.pluto.container.impl.PortletURLImpl;
import org.apache.pluto.container.impl.RenderParametersImpl;
import org.apache.pluto.container.impl.ResourceParametersImpl;
import org.apache.pluto.container.util.StringManager;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.container.ActionScopedRequestAttributeHandler;
import org.apache.pluto.driver.services.container.CachedPortletSession;
import org.apache.pluto.driver.services.container.CachedPortletSessionImpl;
import org.apache.pluto.driver.services.container.PortletURLProviderImpl;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortletParameterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletRequestContextImpl
implements PortletRequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletRequestContextImpl.class);
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final StringManager EXCEPTIONS = StringManager.getManager((String)PortletRequestImpl.class.getPackage().getName());
    private PortletContainer container;
    private HttpServletRequest containerRequest;
    private HttpServletResponse containerResponse;
    private HttpServletRequest dispatchedServletRequest;
    private HttpServletRequest asyncServletRequest;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private final String phase;
    private PortalURL url;
    private PortletConfig portletConfig;
    private ServletContext servletContext;
    private CachedPortletSession cachedPortletSession;
    private Cookie[] cookies;
    private String renderHeaders = null;
    private boolean executingRequestBody = false;
    private Map<String, List<String>> queryParams = null;
    protected final PortletWindow window;
    protected final String windowId;
    protected final PortletURLProvider urlProvider;
    protected final PortletParameterFactory paramFactory;
    protected final ActionScopedRequestAttributeHandler asraHandler;

    public PortletRequestContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, boolean useRequestParameters, String phase) {
        this.container = container;
        this.containerRequest = containerRequest;
        this.containerResponse = containerResponse;
        this.window = window;
        this.windowId = window.getId().getStringId();
        this.url = PortalRequestContext.getContext((HttpServletRequest)containerRequest).createPortalURL();
        this.urlProvider = new PortletURLProviderImpl(this.url, window, this);
        this.paramFactory = this.url.getPortletParameterFactory((PortletRequestContext)this);
        this.phase = phase;
        this.asraHandler = new ActionScopedRequestAttributeHandler(this, this.paramFactory, phase);
    }

    public String getRenderHeaders() {
        return this.renderHeaders;
    }

    public void setRenderHeaders(String renderHeaders) {
        this.renderHeaders = renderHeaders;
    }

    protected boolean isReservedAttributeName(String name) {
        return name.startsWith("javax.servlet.");
    }

    protected String encodeAttributeName(String name) {
        if (this.isReservedAttributeName(name)) {
            return name;
        }
        return this.container.getContainerServices().getNamespaceMapper().encode(this.window.getId(), name);
    }

    protected String decodeAttributeName(String name) {
        if (this.isReservedAttributeName(name)) {
            return name;
        }
        String result = this.container.getContainerServices().getNamespaceMapper().decode(this.window.getId(), name);
        return result != null ? result : name;
    }

    protected PortalURL getPortalURL() {
        return this.url;
    }

    public void init(PortletConfig portletConfig, ServletContext servletContext, HttpServletRequest servletRequest, HttpServletResponse servletResponse, PortletResponseContext responseContext) {
        this.portletConfig = portletConfig;
        this.servletContext = servletContext;
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        this.asraHandler.init(responseContext);
    }

    public void startDispatch(HttpServletRequest wrappedServletRequest, Map<String, List<String>> queryParams, String phase) {
        this.dispatchedServletRequest = wrappedServletRequest;
        this.queryParams = queryParams;
        if (LOG.isTraceEnabled()) {
            StringBuilder txt = new StringBuilder();
            txt.append("Added query parameters.");
            txt.append(" Phase: ").append(phase);
            txt.append(", names: ").append(queryParams.keySet());
            LOG.debug(txt.toString());
        }
    }

    public void endDispatch() {
        this.dispatchedServletRequest = null;
        this.queryParams = null;
        if (LOG.isTraceEnabled()) {
            LOG.debug("deleted query parameters.");
        }
    }

    public HttpServletRequest getAsyncServletRequest() {
        return this.asyncServletRequest;
    }

    public void setAsyncServletRequest(HttpServletRequest asyncServletRequest) {
        this.asyncServletRequest = asyncServletRequest;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public String getPhase() {
        return this.phase;
    }

    private HttpServletRequest getHttpReq() {
        return this.dispatchedServletRequest != null ? this.dispatchedServletRequest : this.servletRequest;
    }

    public Object getAttribute(String name) {
        Object value = null;
        if (this.asraHandler.isActive()) {
            value = this.asraHandler.getAttribute(name);
        }
        if (value == null) {
            value = this.getHttpReq().getAttribute(this.encodeAttributeName(name));
        }
        if (value == null) {
            value = this.getHttpReq().getAttribute(name);
        }
        return value;
    }

    public Enumeration<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        if (this.asraHandler.isActive()) {
            names.addAll(this.asraHandler.getAttributeNames());
        }
        Enumeration e = this.getHttpReq().getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(this.decodeAttributeName((String)e.nextElement()));
        }
        return Collections.enumeration(names);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            if (this.asraHandler.isActive()) {
                this.asraHandler.removeAttribute(name);
            }
            this.getHttpReq().removeAttribute(this.encodeAttributeName(name));
        } else {
            boolean handled = false;
            if (this.asraHandler.isSettable()) {
                handled = this.asraHandler.setAttribute(name, value);
            }
            if (!handled) {
                this.getHttpReq().setAttribute(this.encodeAttributeName(name), value);
            }
        }
    }

    public PortletContainer getContainer() {
        return this.container;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            this.cookies = this.servletRequest.getCookies();
            if (this.cookies == null) {
                this.cookies = new Cookie[0];
            }
        }
        return this.cookies.length > 0 ? (Cookie[])this.cookies.clone() : null;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public PortletSession getPortletSession(boolean create) {
        if (isDebug) {
            LOG.debug("Retrieving portlet session (create=" + create + ")");
        }
        if (this.cachedPortletSession == null || this.cachedPortletSession.isInvalidated()) {
            if (this.portletConfig == null) {
                throw new IllegalStateException(EXCEPTIONS.getString("error.session.illegalState"));
            }
            HttpSession httpSession = this.getServletRequest().getSession(create);
            if (httpSession != null) {
                int maxInactiveInterval = httpSession.getMaxInactiveInterval();
                long lastAccesstime = httpSession.getLastAccessedTime();
                if (maxInactiveInterval >= 0 && lastAccesstime > 0L) {
                    long maxInactiveTime = (long)httpSession.getMaxInactiveInterval() * 1000L;
                    long currentInactiveTime = System.currentTimeMillis() - lastAccesstime;
                    if (currentInactiveTime > maxInactiveTime) {
                        if (isDebug) {
                            LOG.debug("The underlying HttpSession is expired and should be invalidated.");
                        }
                        httpSession.invalidate();
                        httpSession = this.getServletRequest().getSession(create);
                    }
                }
            }
            if (httpSession == null) {
                if (isDebug) {
                    LOG.debug("The underlying HttpSession is not available: no session will be returned.");
                }
                return null;
            }
            ContainerServices containerServices = this.container.getContainerServices();
            PortletEnvironmentService portletEnvironmentService = containerServices.getPortletEnvironmentService();
            this.cachedPortletSession = new CachedPortletSessionImpl(portletEnvironmentService.createPortletSession(this.portletConfig.getPortletContext(), this.getPortletWindow(), httpSession));
        }
        return this.cachedPortletSession;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public PortletWindow getPortletWindow() {
        return this.window;
    }

    public Locale getPreferredLocale() {
        return this.servletRequest.getLocale();
    }

    public Map<String, String[]> getProperties() {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        Enumeration names = this.servletRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            ArrayList values = new ArrayList();
            Enumeration headers = this.servletRequest.getHeaders(name);
            while (headers.hasMoreElements()) {
                values.add(headers.nextElement());
            }
            int size = values.size();
            if (size <= 0) continue;
            properties.put(name, values.toArray(new String[size]));
        }
        return properties;
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramFactory.getParameterMap(this.window.getId().getStringId());
    }

    public Map<String, String[]> getPrivateParameterMap() {
        return this.paramFactory.getPrivateParameterMap(this.window.getId().getStringId());
    }

    public Map<String, String[]> getPublicParameterMap() {
        return this.paramFactory.getPublicParameterMap(this.window.getId().getStringId());
    }

    public HttpServletRequest getContainerRequest() {
        return this.containerRequest;
    }

    public HttpServletResponse getContainerResponse() {
        return this.containerResponse;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public RenderParameters getRenderParameters() {
        return new RenderParametersImpl(this.urlProvider, this.windowId);
    }

    public ActionParameters getActionParameters() {
        return new ActionParametersImpl(this.urlProvider, this.windowId);
    }

    public DispatcherType getDispatcherType() {
        DispatcherType type = this.getServletRequest().getDispatcherType();
        if (isTrace) {
            StringBuilder txt = new StringBuilder();
            txt.append("Dispatcher type: ").append(type);
            txt.append(", executing request body: ").append(this.executingRequestBody);
            LOG.trace(txt.toString());
        }
        if (this.executingRequestBody && type != DispatcherType.ASYNC) {
            type = DispatcherType.REQUEST;
        }
        return type;
    }

    public boolean isExecutingRequestBody() {
        return this.executingRequestBody;
    }

    public void setExecutingRequestBody(boolean executingRequestBody) {
        this.executingRequestBody = executingRequestBody;
    }

    static {
        PortletURLProviderImpl.load();
        PortletURLImpl.load();
        RenderParametersImpl.load();
        ActionParametersImpl.load();
        ResourceParametersImpl.load();
        MutableRenderParametersImpl.load();
        MutableActionParametersImpl.load();
        MutableResourceParametersImpl.load();
    }
}

