/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceParameters;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.AsyncContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.pluto.container.PortletAsyncManager;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletResourceRequestContext;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.impl.HttpServletPortletRequestWrapper;
import org.apache.pluto.container.impl.HttpServletPortletResponseWrapper;
import org.apache.pluto.container.impl.ResourceParametersImpl;
import org.apache.pluto.container.impl.ServletPortletSessionProxy;
import org.apache.pluto.driver.services.container.PortletAsyncContextImpl;
import org.apache.pluto.driver.services.container.PortletRequestContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletResourceRequestContextImpl
extends PortletRequestContextImpl
implements PortletResourceRequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortletResourceRequestContextImpl.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private ResourceResponse response;
    private PortletAsyncContextImpl actx;
    private BeanManager beanmgr;

    public PortletResourceRequestContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window) {
        super(container, containerRequest, containerResponse, window, true, "RESOURCE_PHASE");
    }

    public PortletAsyncManager getPortletAsyncContext() {
        return this.actx;
    }

    public String getCacheability() {
        return this.getPortalURL().getCacheability();
    }

    public Map<String, String[]> getPrivateRenderParameterMap() {
        return this.paramFactory.getResourceRenderParameterMap(this.window.getId().getStringId());
    }

    public String getResourceID() {
        return this.getPortalURL().getResourceID();
    }

    public ResourceParameters getResourceParameters() {
        return new ResourceParametersImpl(this.urlProvider, this.windowId);
    }

    public ResourceResponse getResponse() {
        return this.response;
    }

    public void setResponse(ResourceResponse response) {
        this.response = response;
    }

    public BeanManager getBeanManager() {
        return this.beanmgr;
    }

    public void setBeanManager(BeanManager beanmgr) {
        this.beanmgr = beanmgr;
    }

    public AsyncContext startAsync(ResourceRequest request) throws IllegalStateException {
        return this.startAsync(request, this.response, true);
    }

    public AsyncContext startAsync(ResourceRequest resreq, ResourceResponse resresp, boolean origReqResp) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("This portlet does not support asynchronous mode.");
        }
        if (this.actx != null && this.actx.isComplete()) {
            return null;
        }
        HttpServletRequest hreq = this.getServletRequest();
        HttpServletResponse hresp = this.getServletResponse();
        PortletConfig cfg = this.getPortletConfig();
        if (isTrace) {
            ArrayList attrNames = Collections.list(hreq.getAttributeNames());
            StringBuilder txt = new StringBuilder(128);
            txt.append("Start async before:");
            txt.append("\nAttribute names: ").append(attrNames);
            txt.append("\nasync_request_uri:      ").append((String)hreq.getAttribute("javax.servlet.async.request_uri"));
            txt.append("\nasync_context_path:      ").append((String)hreq.getAttribute("javax.servlet.async.context_path"));
            txt.append("\nasync_servlet_path:      ").append((String)hreq.getAttribute("javax.servlet.async.servlet_path"));
            txt.append("\nasync_path_info:      ").append((String)hreq.getAttribute("javax.servlet.async.path_info"));
            txt.append("\nasync_query_string:      ").append((String)hreq.getAttribute("javax.servlet.async.query_string"));
            txt.append("\nforward_request_uri:      ").append((String)hreq.getAttribute("javax.servlet.forward.request_uri"));
            txt.append("\nforward_context_path:      ").append((String)hreq.getAttribute("javax.servlet.forward.context_path"));
            txt.append("\nforward_servlet_path:      ").append((String)hreq.getAttribute("javax.servlet.forward.servlet_path"));
            txt.append("\nforward_path_info:      ").append((String)hreq.getAttribute("javax.servlet.forward.path_info"));
            txt.append("\nforward_query_string:      ").append((String)hreq.getAttribute("javax.servlet.forward.query_string"));
            txt.append("\ninclude_request_uri:      ").append((String)hreq.getAttribute("javax.servlet.include.request_uri"));
            txt.append("\ninclude_context_path:      ").append((String)hreq.getAttribute("javax.servlet.include.context_path"));
            txt.append("\ninclude_servlet_path:      ").append((String)hreq.getAttribute("javax.servlet.include.servlet_path"));
            txt.append("\ninclude_path_info:      ").append((String)hreq.getAttribute("javax.servlet.include.path_info"));
            txt.append("\ninclude_query_string:      ").append((String)hreq.getAttribute("javax.servlet.include.query_string"));
            txt.append("\nmethod_request_uri:      ").append(hreq.getRequestURI());
            txt.append("\nmethod_context_path:      ").append(hreq.getContextPath());
            txt.append("\nmethod_servlet_path:      ").append(hreq.getServletPath());
            txt.append("\nmethod_path_info:      ").append(hreq.getPathInfo());
            txt.append("\nmethod_query_string:      ").append(hreq.getQueryString());
            LOG.debug(txt.toString());
        }
        resreq.setAttribute("javax.portlet.config", (Object)cfg);
        resreq.setAttribute("javax.portlet.request", (Object)resreq);
        resreq.setAttribute("javax.portlet.response", (Object)resresp);
        HttpServletRequest wreq = this.getAsyncServletRequest();
        if (wreq == null) {
            wreq = new HttpServletPortletRequestWrapper(hreq, this.getSession(), (PortletRequest)resreq);
            ((HttpServletPortletRequestWrapper)wreq).startAsyncProcessing();
        }
        HttpServletPortletResponseWrapper wresp = new HttpServletPortletResponseWrapper(hresp, (PortletRequest)resreq, (PortletResponse)resresp, false);
        if (this.actx != null) {
            this.actx.setWrapped(hreq.startAsync((ServletRequest)wreq, (ServletResponse)wresp));
        } else {
            this.actx = new PortletAsyncContextImpl(hreq.startAsync((ServletRequest)wreq, (ServletResponse)wresp), this, resreq, resresp, origReqResp);
        }
        if (isTrace) {
            ArrayList attrNames = Collections.list(hreq.getAttributeNames());
            StringBuilder txt = new StringBuilder(128);
            txt.append("Start async after (wreq):");
            txt.append("\nAttribute names: ").append(attrNames);
            txt.append("\nasync_request_uri:      ").append((String)wreq.getAttribute("javax.servlet.async.request_uri"));
            txt.append("\nasync_context_path:      ").append((String)wreq.getAttribute("javax.servlet.async.context_path"));
            txt.append("\nasync_servlet_path:      ").append((String)wreq.getAttribute("javax.servlet.async.servlet_path"));
            txt.append("\nasync_path_info:      ").append((String)wreq.getAttribute("javax.servlet.async.path_info"));
            txt.append("\nasync_query_string:      ").append((String)wreq.getAttribute("javax.servlet.async.query_string"));
            txt.append("\nforward_request_uri:      ").append((String)wreq.getAttribute("javax.servlet.forward.request_uri"));
            txt.append("\nforward_context_path:      ").append((String)wreq.getAttribute("javax.servlet.forward.context_path"));
            txt.append("\nforward_servlet_path:      ").append((String)wreq.getAttribute("javax.servlet.forward.servlet_path"));
            txt.append("\nforward_path_info:      ").append((String)wreq.getAttribute("javax.servlet.forward.path_info"));
            txt.append("\nforward_query_string:      ").append((String)wreq.getAttribute("javax.servlet.forward.query_string"));
            txt.append("\ninclude_request_uri:      ").append((String)wreq.getAttribute("javax.servlet.include.request_uri"));
            txt.append("\ninclude_context_path:      ").append((String)wreq.getAttribute("javax.servlet.include.context_path"));
            txt.append("\ninclude_servlet_path:      ").append((String)wreq.getAttribute("javax.servlet.include.servlet_path"));
            txt.append("\ninclude_path_info:      ").append((String)wreq.getAttribute("javax.servlet.include.path_info"));
            txt.append("\ninclude_query_string:      ").append((String)wreq.getAttribute("javax.servlet.include.query_string"));
            txt.append("\nmethod_request_uri:      ").append(wreq.getRequestURI());
            txt.append("\nmethod_context_path:      ").append(wreq.getContextPath());
            txt.append("\nmethod_servlet_path:      ").append(wreq.getServletPath());
            txt.append("\nmethod_path_info:      ").append(wreq.getPathInfo());
            txt.append("\nmethod_query_string:      ").append(wreq.getQueryString());
            LOG.debug(txt.toString());
        }
        return this.actx;
    }

    public AsyncContext startAsync() {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("This portlet does not support asynchronous mode.");
        }
        if (this.actx != null && this.actx.isComplete()) {
            return null;
        }
        AsyncContext ac = this.getServletRequest().startAsync();
        if (this.actx == null) {
            LOG.error("====>>> Wrapper invocation invalid before resource async started.");
        } else {
            this.actx.setWrapped(ac);
        }
        return this.actx;
    }

    public AsyncContext startAsync(ServletRequest request, ServletResponse response) {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("This portlet does not support asynchronous mode.");
        }
        if (this.actx != null && this.actx.isComplete()) {
            return null;
        }
        AsyncContext ac = this.getServletRequest().startAsync(request, response);
        if (this.actx == null) {
            LOG.error("====>>> Wrapper invocation invalid before resource async started.");
        } else {
            this.actx.setWrapped(ac);
        }
        return this.actx;
    }

    public boolean isAsyncStarted() {
        return this.getServletRequest().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.getPortletWindow().getPortletDefinition().isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("This portlet does not support asynchronous mode.");
        }
        if (this.actx != null) {
            if (this.actx.isComplete()) {
                return null;
            }
            return this.actx;
        }
        return this.getServletRequest().getAsyncContext();
    }

    public HttpSession getSession() {
        HttpSession sess = null;
        PortletConfig portletConfig = this.getPortletConfig();
        Map containerRuntimeOptions = portletConfig.getContainerRuntimeOptions();
        String[] values = (String[])containerRuntimeOptions.get("javax.portlet.servletDefaultSessionScope");
        if (values != null && values.length > 0 && "PORTLET_SCOPE".equals(values[0])) {
            String portletWindowId = this.getPortletWindow().getId().getStringId();
            sess = ServletPortletSessionProxy.createProxy((HttpServletRequest)this.getServletRequest(), (String)portletWindowId);
        }
        return sess;
    }

    @Override
    public void setExecutingRequestBody(boolean executingRequestBody) {
        if (this.actx != null && !executingRequestBody) {
            this.actx.setContextInactive();
        }
        super.setExecutingRequestBody(executingRequestBody);
    }
}

