/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.container;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.portlet.Event;
import javax.portlet.MutableRenderParameters;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.EventProvider;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletRequestContext;
import org.apache.pluto.container.PortletStateAwareResponseContext;
import org.apache.pluto.container.PortletURLProvider;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.impl.MutableRenderParametersImpl;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.container.EventProviderImpl;
import org.apache.pluto.driver.services.container.PortletResponseContextImpl;
import org.apache.pluto.driver.services.container.PortletURLProviderImpl;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PortletStateAwareResponseContextImpl
extends PortletResponseContextImpl
implements PortletStateAwareResponseContext {
    private final Logger LOGGER = LoggerFactory.getLogger(PortletStateAwareResponseContextImpl.class);
    private final boolean isDebug = this.LOGGER.isDebugEnabled();
    private List<Event> events;
    private PortletURLProviderImpl portletURLProvider;
    private EventProviderImpl eventProviderImpl;

    public PortletStateAwareResponseContextImpl(PortletContainer container, HttpServletRequest containerRequest, HttpServletResponse containerResponse, PortletWindow window, PortletRequestContext requestContext) {
        super(container, containerRequest, containerResponse, window, requestContext);
        this.portletURLProvider = new PortletURLProviderImpl(this.getPortalURL(), PortletURLProvider.TYPE.RENDER, window, this.getRequestContext());
        this.eventProviderImpl = new EventProviderImpl(this.getPortletWindow(), PlutoServices.getServices().getPortletRegistryService());
        if (this.isDebug) {
            this.LOGGER.debug("Initialized.");
        }
    }

    protected PortletURLProvider getPortletURLProvider() {
        return this.portletURLProvider;
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            super.close();
            if (this.isDebug) {
                this.LOGGER.debug("Applying the changes.");
            }
            PortalURL url = this.portletURLProvider.apply();
            if (this.isDebug) {
                this.LOGGER.debug("Merging.");
            }
            PortalRequestContext.getContext((HttpServletRequest)this.getServletRequest()).mergePortalURL(url, this.getPortletWindow().getId().getStringId());
            if (this.isDebug) {
                this.LOGGER.debug("exiting.");
            }
        }
    }

    @Override
    public void release() {
        this.events = null;
        this.portletURLProvider = null;
        super.release();
    }

    public void reset() {
        this.events = null;
        this.portletURLProvider = new PortletURLProviderImpl(this.getPortalURL(), PortletURLProvider.TYPE.RENDER, this.getPortletWindow(), this.getRequestContext());
    }

    public List<Event> getEvents() {
        if (this.isReleased()) {
            return null;
        }
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        return this.events;
    }

    public PortletMode getPortletMode() {
        return this.isClosed() ? null : this.portletURLProvider.getPortletMode();
    }

    public WindowState getWindowState() {
        return this.isClosed() ? null : this.portletURLProvider.getWindowState();
    }

    public void setPortletMode(PortletMode portletMode) {
        if (!this.isClosed()) {
            this.portletURLProvider.setPortletMode(portletMode);
        }
    }

    public void setWindowState(WindowState windowState) {
        if (!this.isClosed()) {
            this.portletURLProvider.setWindowState(windowState);
        }
    }

    public EventProvider getEventProvider() {
        return this.isClosed() ? null : this.eventProviderImpl;
    }

    public void addPublicRenderParameter(String windowId, String name, String[] values) {
        if (!this.isClosed()) {
            this.portletURLProvider.addPublicRenderParameter(windowId, name, values);
        }
    }

    public void removePublicRenderParameter(String windowId, String name) {
        if (!this.isClosed()) {
            this.portletURLProvider.removePublicRenderParameter(windowId, name);
        }
    }

    public boolean isPublicRenderParameter(String windowId, String name) {
        boolean ret = false;
        if (!this.isClosed()) {
            ret = this.portletURLProvider.isPublicRenderParameter(windowId, name);
        }
        return ret;
    }

    public Set<String> getPrivateParameterNames(String windowId) {
        Set<String> pns = new HashSet<String>();
        if (!this.isClosed()) {
            pns = this.portletURLProvider.getPrivateParameterNames(windowId);
        }
        return pns;
    }

    public String[] getParameterValues(String windowId, String name) {
        String[] vals = new String[]{};
        if (!this.isClosed()) {
            vals = this.portletURLProvider.getParameterValues(windowId, name);
        }
        return vals;
    }

    public void setParameter(String windowId, String name, String[] values) {
        if (!this.isClosed()) {
            this.portletURLProvider.setParameter(windowId, name, values);
        }
    }

    public void removeParameter(String windowId, String name) {
        if (!this.isClosed()) {
            this.portletURLProvider.removeParameter(windowId, name);
        }
    }

    public MutableRenderParameters getRenderParameters(String windowId) {
        return new MutableRenderParametersImpl((PortletURLProvider)this.portletURLProvider, windowId);
    }
}

