/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.impl.resource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pluto.container.PageResourceId;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PageResources;
import org.apache.pluto.driver.services.portal.PropertyConfigService;
import org.apache.pluto.driver.services.portal.RenderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceConfig
implements PropertyConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceConfig.class);
    private String portalName;
    private String portalVersion;
    private String containerName;
    private final Set<String> supportedPortletModes = new HashSet<String>();
    private final Set<String> supportedWindowStates = new HashSet<String>();
    private final PageResources pageResources = new PageResources();
    private List<PageResourceId> defaultPageResources = new ArrayList<PageResourceId>();
    private RenderConfig renderConfig;

    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    public String getPortalVersion() {
        return this.portalVersion;
    }

    public void setPortalVersion(String portalVersion) {
        this.portalVersion = portalVersion;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public Set<String> getSupportedPortletModes() {
        return this.supportedPortletModes;
    }

    public void setSupportedPortletModes(Set<String> supportedPortletModes) {
        this.supportedPortletModes.clear();
        this.supportedPortletModes.addAll(supportedPortletModes);
    }

    public void addSupportedPortletMode(String mode) {
        this.supportedPortletModes.add(mode);
    }

    public Set<String> getSupportedWindowStates() {
        return this.supportedWindowStates;
    }

    public void setSupportedWindowStates(Set<String> supportedWindowStates) {
        this.supportedWindowStates.clear();
        this.supportedWindowStates.addAll(supportedWindowStates);
    }

    public void addSupportedWindowState(String state) {
        this.supportedWindowStates.add(state);
    }

    public PageResources getResources() {
        return this.pageResources;
    }

    public void addResource(String name, String scope, String version, String sType, String source) {
        PageResourceId resid = new PageResourceId(name, scope, version);
        PageResources.Type type = null;
        try {
            type = PageResources.Type.valueOf((String)sType.toUpperCase());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.pageResources.addResource(resid, type, source);
    }

    public List<PageResourceId> getDefaultPageDependencies() {
        return this.defaultPageResources;
    }

    public void addDefaultPageDependency(String name, String scope, String version) {
        if (name != null) {
            PageResourceId resid = new PageResourceId(name, scope, version);
            this.defaultPageResources.add(resid);
        } else {
            LOG.warn("Resource name cannot be null.");
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Adding resource dependency. # deps: ").append(this.defaultPageResources.size());
            txt.append(", name: ").append(name);
            txt.append(", scope: ").append(scope);
            txt.append(", version: ").append(version);
            LOG.debug(txt.toString());
        }
    }

    public RenderConfig getRenderConfig() {
        return this.renderConfig;
    }

    public void setRenderConfig(RenderConfig renderConfig) {
        this.renderConfig = renderConfig;
    }

    public void initialized() {
        this.pageResources.initialized();
        if (this.defaultPageResources.isEmpty()) {
            this.defaultPageResources.add(new PageResourceId("pluto.css", "org.apache.portals", "3.0.0"));
            this.defaultPageResources.add(new PageResourceId("portlet-spec-1.0.css", "org.apache.portals", "1.0.0"));
            this.defaultPageResources.add(new PageResourceId("portlet-spec-2.0.css", "org.apache.portals", "2.0.0"));
            this.defaultPageResources.add(new PageResourceId("pluto.js", "org.apache.portals", "3.0.0"));
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Logging config info.\n");
            txt.append(this.pageResources.toString());
            txt.append("\n\nDefault page dependencies:");
            for (PageResourceId id : this.defaultPageResources) {
                txt.append("\n   ").append(id.toString());
            }
            txt.append("\n\nDeclared page dependencies:");
            for (PageConfig pc : this.renderConfig.getPages()) {
                if (pc.getPageResources().isEmpty()) continue;
                txt.append("\n   Page: ").append(pc.getName());
                for (PageResourceId id : pc.getPageResources()) {
                    txt.append("\n      ").append(id.toString());
                }
            }
            LOG.debug(txt.toString());
        }
    }
}

