/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.container.HeaderData;
import org.apache.pluto.container.PageResourceId;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.container.om.portlet.ContainerRuntimeOption;
import org.apache.pluto.container.om.portlet.Dependency;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.driver.PartialActionResponse;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PageResources;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.util.PageState;
import org.apache.pluto.driver.util.RenderData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalDriverServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PortalDriverServlet.class);
    private ServletContext servletContext = null;
    public static final String DEFAULT_PAGE_URI = "/WEB-INF/themes/pluto-default-theme.jsp";
    protected PortletContainer container = null;
    private String contentType = "";

    public String getServletInfo() {
        return "Pluto Portal Driver Servlet";
    }

    public void init() {
        this.servletContext = this.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
        String charset = this.getServletConfig().getInitParameter("charset");
        if (charset != null && charset.length() > 0) {
            this.contentType = "text/html; charset=" + charset;
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Start of PortalDriverServlet.doGet() to process portlet request . . .");
        }
        if (this.contentType != "") {
            response.setContentType(this.contentType);
        }
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = null;
        try {
            portalURL = portalRequestContext.getRequestedPortalURL();
        }
        catch (Exception ex) {
            String msg = "Cannot handle request for portal URL. Problem: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        String targetWindow = portalURL.getTargetWindow();
        if (targetWindow != null && portalURL.getType() != PortalURL.URLType.Render && portalURL.getType() != PortalURL.URLType.Portal) {
            String reqType = portalURL.getType().toString();
            PortletWindowConfig windowConfig = PortletWindowConfig.fromId(targetWindow);
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, windowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing " + reqType + " request for window: " + portletWindow.getId().getStringId());
            }
            try {
                switch (portalURL.getType()) {
                    case Action: {
                        this.container.doAction((PortletWindow)portletWindow, request, response, true);
                        break;
                    }
                    case AjaxAction: {
                        this.container.doAction((PortletWindow)portletWindow, request, response, false);
                        response.setContentType("application/json");
                        PageState ps = new PageState(request);
                        PrintWriter writer = response.getWriter();
                        String jsondata = ps.toJSONString();
                        LOG.debug("Ajax Action: returning new page state to client: " + jsondata);
                        ((Writer)writer).write(jsondata);
                        break;
                    }
                    case PartialAction: {
                        this.container.doAction((PortletWindow)portletWindow, request, response, false);
                        HashMap<String, RenderData> renderDataMap = new HashMap<String, RenderData>();
                        PartialActionResponse partialActionResponse = new PartialActionResponse(response);
                        this.container.doServeResource((PortletWindow)portletWindow, request, (HttpServletResponse)partialActionResponse);
                        String pid = portletWindow.getId().getStringId();
                        renderDataMap.put(pid, partialActionResponse.getRenderData());
                        PageState ps = new PageState(request, renderDataMap);
                        String jsondata = ps.toJSONString();
                        LOG.debug("Ajax Action: returning new page state to client: " + jsondata);
                        response.setContentType("application/json");
                        PrintWriter responseWriter = response.getWriter();
                        ((Writer)responseWriter).write(jsondata);
                        break;
                    }
                    case Resource: {
                        this.container.doServeResource((PortletWindow)portletWindow, request, response);
                        break;
                    }
                    default: {
                        LOG.warn("Unknown request: " + reqType);
                        break;
                    }
                }
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(reqType + " request processed.\n");
            }
        } else {
            String uri;
            PageConfig pageConfig;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing render request.");
            }
            if ((pageConfig = portalURL.getPageConfig(this.servletContext)) == null) {
                String renderPath = portalURL == null ? "" : portalURL.getRenderPath();
                String msg = "PageConfig for render path [" + renderPath + "] could not be found.";
                LOG.error(msg);
                throw new ServletException(msg);
            }
            request.setAttribute("currentPage", (Object)pageConfig);
            String string = uri = pageConfig.getUri() != null ? pageConfig.getUri() : DEFAULT_PAGE_URI;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing header requests for target portlets.");
            }
            response.setContentType("text/html;charset=UTF-8");
            this.doHeaders(request, response, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dispatching to: " + uri);
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(uri);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Render request processed.\n");
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void doHeaders(HttpServletRequest req, HttpServletResponse resp, PortalURL purl) throws ServletException, IOException {
        ServletContext sc = req.getServletContext();
        DriverConfiguration dc = (DriverConfiguration)sc.getAttribute("driverConfig");
        StringBuilder markup = new StringBuilder(128);
        ArrayList<PageResourceId> portletdeps = new ArrayList<PageResourceId>();
        ArrayList<PageResourceId> dynamicdeps = new ArrayList<PageResourceId>();
        HashMap dynamicResources = new HashMap();
        for (String pid : purl.getPortletIds()) {
            HeaderData hd = null;
            PortletWindowConfig wcfg = null;
            PortletWindowImpl pwin = null;
            try {
                wcfg = PortletWindowConfig.fromId(pid);
                pwin = new PortletWindowImpl(this.container, wcfg, purl);
            }
            catch (Throwable e) {
                LOG.warn("Could not retrieve configuration for portlet ID: " + pid);
                continue;
            }
            try {
                Object headers;
                ContainerRuntimeOption crt;
                String appName = wcfg.getContextPath();
                String portletName = PortletWindowConfig.parsePortletName(pid);
                PortletDefinition pd = dc.getPortletRegistryService().getPortletApplication(appName).getPortlet(portletName);
                if (purl.isVersion3(pid)) {
                    hd = this.container.doHeader((PortletWindow)pwin, req, resp);
                    for (Dependency dep : pd.getDependencies()) {
                        portletdeps.add(new PageResourceId(dep.getName(), dep.getScope(), dep.getVersion()));
                    }
                    Map resources = hd.getDynamicResources();
                    for (PageResourceId id : resources.keySet()) {
                        dynamicdeps.add(id);
                        if (resources.get(id) == null) continue;
                        dynamicResources.put(id, resources.get(id));
                    }
                } else if (purl.getVersion(pid).equalsIgnoreCase("2.0") && (crt = pd.getContainerRuntimeOption("javax.portlet.renderHeaders")) != null && (headers = crt.getValues()).size() == 1 && ((String)headers.get(0)).equalsIgnoreCase("true")) {
                    hd = this.container.doRender((PortletWindow)pwin, req, resp, "RENDER_HEADERS");
                }
                if (hd == null) continue;
                markup.append(hd.getHeadSectionMarkup()).append("\n");
                List cookies = hd.getCookies();
                for (Cookie c : cookies) {
                    resp.addCookie(c);
                }
                headers = hd.getHttpHeaders();
                for (String name : headers.keySet()) {
                    for (String val : (List)headers.get(name)) {
                        resp.addHeader(name, val);
                    }
                }
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
        }
        req.setAttribute("headMarkup", (Object)markup.toString());
        markup.setLength(0);
        PageResources pageres = dc.getRenderConfigService().getPageResources();
        if (!dynamicResources.isEmpty()) {
            pageres = new PageResources(pageres);
            for (PageResourceId id : dynamicResources.keySet()) {
                pageres.addResource(id, PageResources.Type.MARKUP, (String)dynamicResources.get(id));
            }
        }
        ArrayList<PageResourceId> deps = new ArrayList<PageResourceId>(dc.getRenderConfigService().getDefaultPageDependencies());
        int defDespSize = deps.size();
        List<PageResourceId> pagedeps = purl.getPageConfig(req.getServletContext()).getPageResources();
        deps.addAll(pagedeps);
        deps.addAll(portletdeps);
        deps.addAll(dynamicdeps);
        if (LOG.isDebugEnabled()) {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Page dependency list.");
            txt.append(" total deps: ").append(deps.size());
            txt.append(", default deps: ").append(defDespSize);
            txt.append(", page deps: ").append(pagedeps.size());
            txt.append(", portlet deps: ").append(portletdeps.size());
            txt.append(", dynamic deps: ").append(dynamicdeps.size());
            for (PageResourceId id : deps) {
                txt.append("\n   ").append(id.toString());
            }
            LOG.debug(txt.toString());
        }
        markup.append(pageres.getMarkup(deps, req.getContextPath()));
        req.setAttribute("dynamicResources", (Object)markup.toString());
    }
}

