/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.driver.config.AdminConfiguration;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.config.DriverConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class PortalStartupListener
extends ContextLoaderListener {
    private static final Logger LOG = LoggerFactory.getLogger(PortalStartupListener.class);
    private static final String CONTAINER_KEY = "portletContainer";
    private static final String DRIVER_CONFIG_KEY = "driverConfig";
    private static final String ADMIN_CONFIG_KEY = "driverAdminConfig";
    private static ServletContext servletContext;

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext;
        LOG.info("Starting up Pluto Portal Driver. . .");
        PortalStartupListener.servletContext = servletContext = event.getServletContext();
        super.contextInitialized(event);
        WebApplicationContext springContext = null;
        try {
            springContext = (WebApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        catch (RuntimeException ex) {
            String msg = "Problem getting Spring context: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw ex;
        }
        LOG.debug(" [1a] Loading DriverConfiguration. . . ");
        DriverConfiguration driverConfiguration = (DriverConfiguration)springContext.getBean("DriverConfiguration");
        LOG.debug(" [1b] Registering DriverConfiguration. . .");
        servletContext.setAttribute(DRIVER_CONFIG_KEY, (Object)driverConfiguration);
        LOG.debug(" [2a] Loading Optional AdminConfiguration. . .");
        AdminConfiguration adminConfiguration = (AdminConfiguration)springContext.getBean("AdminConfiguration");
        if (adminConfiguration != null) {
            LOG.debug(" [2b] Registering Optional AdminConfiguration");
            servletContext.setAttribute(ADMIN_CONFIG_KEY, (Object)adminConfiguration);
        } else {
            LOG.info("Optional AdminConfiguration not found. Ignoring.");
        }
        LOG.info("Initializing Portlet Container. . .");
        LOG.debug(" [1] Creating portlet container...");
        PortletContainer container = (PortletContainer)springContext.getBean("PortletContainer");
        servletContext.setAttribute(CONTAINER_KEY, (Object)container);
        LOG.info("Pluto portlet container started.");
        LOG.info("********** Pluto Portal Driver Started **********\n\n");
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        if (LOG.isInfoEnabled()) {
            LOG.info("Shutting down Pluto Portal Driver...");
        }
        this.destroyContainer(servletContext);
        this.destroyAdminConfiguration(servletContext);
        this.destroyDriverConfiguration(servletContext);
        if (LOG.isInfoEnabled()) {
            LOG.info("********** Pluto Portal Driver Shut Down **********\n\n");
        }
        super.contextDestroyed(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyContainer(ServletContext servletContext) {
        PortletContainer container;
        if (LOG.isInfoEnabled()) {
            LOG.info("Shutting down Pluto Portal Driver...");
        }
        if ((container = (PortletContainer)servletContext.getAttribute(CONTAINER_KEY)) != null) {
            try {
                container.destroy();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Pluto Portal Driver shut down.");
                }
            }
            catch (PortletContainerException ex) {
                LOG.error("Unable to shut down portlet container: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                servletContext.removeAttribute(CONTAINER_KEY);
            }
        }
    }

    private void destroyDriverConfiguration(ServletContext servletContext) {
        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute(DRIVER_CONFIG_KEY);
        if (driverConfig != null) {
            servletContext.removeAttribute(DRIVER_CONFIG_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyAdminConfiguration(ServletContext servletContext) {
        AdminConfiguration adminConfig = (AdminConfiguration)servletContext.getAttribute(ADMIN_CONFIG_KEY);
        if (adminConfig != null) {
            try {
                adminConfig.destroy();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Pluto Portal Admin Config destroyed.");
                }
            }
            catch (DriverConfigurationException ex) {
                LOG.error("Unable to destroy portal admin config: " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                servletContext.removeAttribute(ADMIN_CONFIG_KEY);
            }
        }
    }
}

