/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.container;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.xml.namespace.QName;
import org.apache.pluto.container.driver.DriverPortletConfig;
import org.apache.pluto.container.impl.AbstractPortletConfigImpl;
import org.apache.pluto.container.om.portlet.CustomWindowState;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.container.om.portlet.Supports;
import org.apache.pluto.driver.container.ResourceBundleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverPortletConfigImpl
extends AbstractPortletConfigImpl
implements DriverPortletConfig {
    private static final Logger LOG = LoggerFactory.getLogger(DriverPortletConfigImpl.class);
    protected ResourceBundleFactory bundles;

    public DriverPortletConfigImpl(PortletContext portletContext, PortletDefinition portletDD) {
        super(portletContext, portletDD);
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resource Bundle requested: " + locale);
        }
        if (this.bundles == null) {
            this.bundles = new ResourceBundleFactory(this.portlet, this.portlet.getPortletInfo());
        }
        return this.bundles.getResourceBundle(locale);
    }

    public Enumeration<PortletMode> getPortletModes(String mimeType) {
        HashSet<PortletMode> portletModes = this.getPMList(mimeType);
        return Collections.enumeration(portletModes);
    }

    public Enumeration<WindowState> getWindowStates(String mimeType) {
        HashSet<WindowState> windowStates = this.getWSList(mimeType);
        return Collections.enumeration(windowStates);
    }

    public Map<String, QName> getPublicRenderParameterDefinitions() {
        HashMap<String, QName> prpdefs = new HashMap<String, QName>();
        HashMap<String, PublicRenderParameter> prps = new HashMap<String, PublicRenderParameter>();
        for (PublicRenderParameter prp : this.portlet.getApplication().getPublicRenderParameters()) {
            prps.put(prp.getIdentifier(), prp);
        }
        for (String prpname : this.portlet.getSupportedPublicRenderParameters()) {
            PublicRenderParameter prp = (PublicRenderParameter)prps.get(prpname);
            if (prp != null) {
                QName qn = prp.getQName();
                prpdefs.put(prpname, qn);
                continue;
            }
            LOG.warn("Could not get public render parameter definition for identifier: " + prpname);
        }
        return prpdefs;
    }

    private HashSet<PortletMode> getPMList(String mimeType) {
        HashSet<PortletMode> pms = new HashSet<PortletMode>();
        pms.add(PortletMode.VIEW);
        for (Supports s : this.portlet.getSupports()) {
            if (!mimeType.equalsIgnoreCase(s.getMimeType())) continue;
            for (String pmname : s.getPortletModes()) {
                PortletMode pm = new PortletMode(pmname);
                pms.add(pm);
            }
        }
        return pms;
    }

    private HashSet<WindowState> getWSList(String mimeType) {
        HashSet<WindowState> winstates = new HashSet<WindowState>();
        HashSet<WindowState> custWS = new HashSet<WindowState>();
        winstates.add(WindowState.NORMAL);
        winstates.add(WindowState.MAXIMIZED);
        winstates.add(WindowState.MINIMIZED);
        for (CustomWindowState cws : this.portlet.getApplication().getCustomWindowStates()) {
            custWS.add(new WindowState(cws.getWindowState()));
        }
        boolean restricted = false;
        for (Supports s : this.portlet.getSupports()) {
            if (!mimeType.equalsIgnoreCase(mimeType)) continue;
            for (String wsname : s.getWindowStates()) {
                WindowState ws = new WindowState(wsname);
                winstates.add(ws);
                restricted = true;
            }
        }
        if (!restricted) {
            winstates.addAll(custWS);
        }
        return winstates;
    }
}

