/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.core;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalRequestContext {
    private static final Logger LOG = LoggerFactory.getLogger(PortalRequestContext.class);
    private static final String REQUEST_KEY = PortalRequestContext.class.getName();
    private ServletContext servletContext;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private PortalURL requestedPortalURL;

    public PortalRequestContext(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) {
        this.servletContext = servletContext;
        this.request = request;
        this.response = response;
        request.setAttribute(REQUEST_KEY, (Object)this);
    }

    public static PortalRequestContext getContext(HttpServletRequest request) {
        return (PortalRequestContext)request.getAttribute(REQUEST_KEY);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public synchronized PortalURL getRequestedPortalURL() {
        if (this.requestedPortalURL == null) {
            DriverConfiguration config = (DriverConfiguration)this.servletContext.getAttribute("driverConfig");
            if (config != null) {
                PortalURLParser parser = config.getPortalUrlParser();
                this.requestedPortalURL = parser.parse(this.request);
            } else {
                String msg = "Driver configuration not found while parsing portal URL!";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
        return this.requestedPortalURL;
    }

    public PortalURL createPortalURL() {
        return this.getRequestedPortalURL();
    }

    public synchronized void mergePortalURL(PortalURL portalURL, String windowId) {
        this.requestedPortalURL = portalURL;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }
}

