/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.portal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pluto.container.PageResourceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageResources {
    private static final Logger LOG = LoggerFactory.getLogger(PageResources.class);
    private static final boolean isDebug = LOG.isDebugEnabled();
    private static final boolean isTrace = LOG.isTraceEnabled();
    private static final Map<PageResourceId, Source> defaultResources = new HashMap<PageResourceId, Source>();
    private Map<PageResourceId, Source> resources = new HashMap<PageResourceId, Source>();

    public PageResources() {
    }

    public PageResources(PageResources other) {
        for (PageResourceId id : other.resources.keySet()) {
            this.resources.put(new PageResourceId(id), new Source(other.resources.get(id)));
        }
    }

    public void initialized() {
        if (this.resources.isEmpty()) {
            this.resources.putAll(defaultResources);
        }
    }

    public void addResource(PageResourceId id, Type type, String source) {
        StringBuilder txt;
        if (id.getName() != null && type != null && source != null) {
            this.resources.put(id, new Source(type, source));
        } else {
            txt = new StringBuilder(128);
            txt.append("Required value null when adding page Resource");
            txt.append(", id: ").append(id.toString());
            txt.append(", type: ").append(type == null ? "null" : type.toString());
            txt.append(", source: ").append(source);
            LOG.warn(txt.toString());
        }
        if (isDebug) {
            txt = new StringBuilder(128);
            txt.append("Adding page Resource");
            txt.append(", id: ").append(id.toString());
            txt.append(", type: ").append(type == null ? "null" : type.toString());
            txt.append(", source: ").append(source);
            LOG.debug(txt.toString());
        }
    }

    private Source getBestMatch(PageResourceId resid) {
        if (this.resources.containsKey(resid)) {
            return this.resources.get(resid);
        }
        ArrayList<PageResourceId> candidates = new ArrayList<PageResourceId>();
        for (PageResourceId id : this.resources.keySet()) {
            if (!resid.resourceMatches(id)) continue;
            candidates.add(id);
        }
        PageResourceId effectiveId = null;
        if (candidates.size() > 0) {
            if (candidates.size() == 1) {
                effectiveId = (PageResourceId)candidates.get(0);
            } else {
                Collections.sort(candidates);
                for (PageResourceId id : candidates) {
                    if (resid.compareTo(id) > 0) continue;
                    effectiveId = id;
                    break;
                }
                if (effectiveId == null) {
                    effectiveId = (PageResourceId)candidates.get(candidates.size() - 1);
                }
            }
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("Effective page resource ID: ");
            txt.append(effectiveId == null ? "null" : effectiveId.toString());
            LOG.debug(txt.toString());
        }
        if (effectiveId != null) {
            return this.resources.get(effectiveId);
        }
        return null;
    }

    public String getMarkup(PageResourceId resid, String contextPath) {
        String markup = "";
        Source src = this.getBestMatch(resid);
        if (src != null) {
            StringBuilder txt = new StringBuilder(128);
            switch (src.type) {
                case CSS: {
                    txt.append("<link rel='stylesheet' type='text/css' href='");
                    txt.append(contextPath).append(src.source);
                    txt.append("'></link>");
                    break;
                }
                case SCRIPT: {
                    txt.append("<script type='text/javascript' src='");
                    txt.append(contextPath).append(src.source);
                    txt.append("'></script>");
                    break;
                }
                case MARKUP: {
                    txt.append(src.source);
                    break;
                }
                default: {
                    LOG.warn("Unknown page resource type: " + src.type.toString());
                }
            }
            markup = txt.toString();
        } else {
            LOG.warn("Unknown page resource ID: " + resid.toString());
        }
        return markup;
    }

    public String getMarkup(List<PageResourceId> prids, String contextPath) {
        ArrayList<PageResourceId> resultids = new ArrayList<PageResourceId>();
        for (PageResourceId newid : prids) {
            int index = -1;
            for (int ii = 0; ii < resultids.size(); ++ii) {
                if (!((PageResourceId)resultids.get(ii)).resourceMatches(newid)) continue;
                index = ii;
                break;
            }
            if (index == -1) {
                resultids.add(newid);
                continue;
            }
            PageResourceId currid = (PageResourceId)resultids.get(index);
            if (currid.equals((Object)newid)) continue;
            boolean replaceId = false;
            if (currid.getVersion() == null) {
                replaceId = true;
            }
            String currVersion = null;
            String newVersion = null;
            String[] currDecimals = new String[]{};
            String[] newDecimals = new String[]{};
            if (!replaceId && newid.getVersion() != null) {
                String regex = "^[vV=]{0,1}(\\d+(?:\\.\\d+){0,2}).*$";
                currVersion = currid.getVersion().replaceFirst(regex, "$1");
                newVersion = newid.getVersion().replaceFirst(regex, "$1");
                String dottedDecimalRegex = "^\\d+(?:\\.\\d+)*$";
                if (currVersion.matches(dottedDecimalRegex)) {
                    if (newVersion.matches(dottedDecimalRegex)) {
                        currDecimals = currVersion.split("\\.");
                        newDecimals = newVersion.split("\\.");
                        for (int ii = 0; ii < currDecimals.length && ii < newDecimals.length; ++ii) {
                            int currDigit = Integer.parseInt(currDecimals[ii]);
                            int newDigit = Integer.parseInt(newDecimals[ii]);
                            if (newDigit <= currDigit) continue;
                            replaceId = true;
                            break;
                        }
                        if (!replaceId && newDecimals.length > currDecimals.length) {
                            replaceId = true;
                        }
                    }
                } else if (newVersion.matches(dottedDecimalRegex)) {
                    replaceId = true;
                } else {
                    boolean bl = replaceId = currid.getVersion().compareTo(newid.getVersion()) > 0;
                }
            }
            if (!replaceId) continue;
            if (isDebug) {
                StringBuilder txt = new StringBuilder();
                txt.append("Replacing page resource id.");
                txt.append(" old: ").append(currid.toString());
                txt.append(", new: ").append(newid.toString());
                txt.append(", index: ").append(index);
                txt.append(", total length: ").append(resultids.size());
                txt.append("\n   Current version string: ").append(currVersion);
                txt.append(", New version string: ").append(newVersion);
                txt.append(", Current digits: ").append(Arrays.asList(currDecimals));
                txt.append(", New digits: ").append(Arrays.asList(newDecimals));
                LOG.debug(txt.toString());
            }
            resultids.add(index, newid);
            resultids.remove(index + 1);
        }
        StringBuilder markup = new StringBuilder(128);
        for (PageResourceId resid : resultids) {
            markup.append(this.getMarkup(resid, contextPath)).append("\n");
        }
        if (isDebug) {
            StringBuilder txt = new StringBuilder();
            txt.append("\nConsolidated page resource IDs:");
            for (PageResourceId id : resultids) {
                txt.append("\n").append(id.toString());
            }
            txt.append("\n\nResulting markup:\n").append(markup.toString());
            LOG.debug(txt.toString());
        }
        return markup.length() == 0 ? null : markup.toString();
    }

    public String toString() {
        StringBuilder txt = new StringBuilder(128);
        txt.append("Available resources:");
        for (PageResourceId id : this.resources.keySet()) {
            txt.append("\n   ").append(id.toString());
            txt.append(" : ").append(this.resources.get(id).toString());
        }
        return txt.toString();
    }

    static {
        PageResourceId resid = new PageResourceId("pluto.css", "org.apache.portals", "3.0.0");
        Source src = new Source(Type.CSS, "/css/pluto.css");
        defaultResources.put(resid, src);
        resid = new PageResourceId("portlet-spec-1.0.css", "org.apache.portals", "1.0.0");
        src = new Source(Type.CSS, "/css/portlet-spec-1.0.css");
        defaultResources.put(resid, src);
        resid = new PageResourceId("portlet-spec-2.0.css", "org.apache.portals", "2.0.0");
        src = new Source(Type.CSS, "/css/portlet-spec-2.0.css");
        defaultResources.put(resid, src);
        resid = new PageResourceId("pluto.js", "org.apache.portals", "3.0.0");
        src = new Source(Type.SCRIPT, "/javascript/portletHub.js");
        defaultResources.put(resid, src);
    }

    private static class Source {
        Type type;
        String source;

        public Source(Type type, String source) {
            this.type = type;
            this.source = source;
        }

        public Source(Source other) {
            this.type = other.type;
            this.source = other.source;
        }

        public String toString() {
            StringBuilder txt = new StringBuilder(128);
            txt.append("Page resource source. Type: ").append((Object)this.type);
            txt.append(", Source: ").append(this.source);
            return txt.toString();
        }
    }

    public static enum Type {
        CSS,
        SCRIPT,
        MARKUP;

    }
}

