/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.portal;

public class PortletWindowConfig {
    private String contextPath;
    private String portletName;
    private String metaInfo;

    public PortletWindowConfig() {
    }

    private PortletWindowConfig(String contextPath, String portletName, String metaInfo) {
        this.contextPath = contextPath;
        this.portletName = portletName;
        this.metaInfo = metaInfo;
    }

    public String getId() {
        return PortletWindowConfig.createPortletId(this.contextPath, this.portletName, this.metaInfo);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public static String createPortletId(String contextPath, String portletName, String metaInfo) throws NullPointerException, IllegalArgumentException {
        if (contextPath == null) {
            throw new NullPointerException("Context path must not be null.");
        }
        if (portletName == null) {
            throw new NullPointerException("Portlet name must not be null.");
        }
        if (portletName.indexOf(46) != -1) {
            throw new IllegalArgumentException("Portlet name must not have a dot(period). Please remove the dot from the value of the portlet-name element (" + portletName + ") in portlet.xml");
        }
        if (metaInfo == null) {
            metaInfo = "";
        }
        if (contextPath.charAt(0) == '/') {
            contextPath = contextPath.substring(1);
        }
        return contextPath + "." + portletName + "!" + metaInfo;
    }

    public static String parseContextPath(String portletId) {
        int index = PortletWindowConfig.getSeparatorIndex(portletId);
        if (portletId.charAt(0) != '/') {
            return "/" + portletId.substring(0, index);
        }
        return portletId.substring(0, index);
    }

    public static String parsePortletName(String portletId) {
        int index = PortletWindowConfig.getSeparatorIndex(portletId);
        String postfix = portletId.substring(index + 1);
        if ((index = postfix.indexOf("!")) > -1) {
            return postfix.substring(0, index);
        }
        return postfix;
    }

    public static String parseMetaInfo(String portletId) {
        int index = portletId.indexOf("!");
        if (index > -1) {
            return portletId.substring(index + 1);
        }
        return "";
    }

    private static int getSeparatorIndex(String portletId) throws NullPointerException, IllegalArgumentException {
        if (portletId == null) {
            throw new NullPointerException("Portlet ID is null");
        }
        int index = portletId.lastIndexOf(".");
        if (index < 0 || index == portletId.length() - 1) {
            throw new IllegalArgumentException("Portlet ID '" + portletId + "' does not contain a dot");
        }
        return index;
    }

    public static PortletWindowConfig fromId(String portletWindowId) {
        String contextPath = PortletWindowConfig.parseContextPath(portletWindowId);
        String portletName = PortletWindowConfig.parsePortletName(portletWindowId);
        String metaInfo = PortletWindowConfig.parseMetaInfo(portletWindowId);
        return new PortletWindowConfig(contextPath, portletName, metaInfo);
    }
}

