/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.services.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.PublicRenderParameter;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicRenderParameterQNameMapper
implements PublicRenderParameterMapper {
    private final Logger LOGGER = LoggerFactory.getLogger(PublicRenderParameterQNameMapper.class);
    private final boolean isTrace = this.LOGGER.isTraceEnabled();
    private final ArrayList<PortalURLPublicParameter> prpList = new ArrayList();
    private final Map<QName, List<PortalURLPublicParameter>> qn2PRP = new HashMap<QName, List<PortalURLPublicParameter>>();
    private final ArrayList<QName> qnList = new ArrayList();

    public PublicRenderParameterQNameMapper(PageConfig paco, PortletRegistryService pore) {
        Collection<String> pids = paco.getPortletIds();
        this.LOGGER.debug("Setting up the PRP mapper. There are " + pids.size() + " portlets to process.");
        StringBuilder dbgstr = new StringBuilder(1024);
        for (String pid : pids) {
            if (this.isTrace) {
                dbgstr.append("\n  Processing portlet id = " + pid);
            }
            PortletWindowConfig pwc = null;
            PortletApplicationDefinition pad = null;
            PortletDefinition pd = null;
            pwc = PortletWindowConfig.fromId(pid);
            String cxtpa = pwc.getContextPath();
            String portletName = pwc.getPortletName();
            try {
                List prpIds;
                pad = pore.getPortletApplication(cxtpa);
                pd = pore.getPortlet(cxtpa, portletName);
                if (this.isTrace) {
                    dbgstr.append("\n    For context: " + cxtpa + ", App name is " + pad.getName() + ", portlet name is " + pd.getPortletName());
                }
                if ((prpIds = pd.getSupportedPublicRenderParameters()) == null || prpIds.size() <= 0) continue;
                List prpDefs = pad.getPublicRenderParameters();
                for (String prpId : prpIds) {
                    Iterator i = prpDefs.iterator();
                    QName qn = null;
                    while (qn == null && i.hasNext()) {
                        PublicRenderParameter prpDef = (PublicRenderParameter)i.next();
                        if (!prpDef.getIdentifier().equals(prpId)) continue;
                        qn = prpDef.getQName();
                    }
                    if (qn == null) {
                        this.LOGGER.error("Problem with PRP definition: Both QName could not be obtained.");
                        continue;
                    }
                    PortalURLPublicParameter pupp = new PortalURLPublicParameter(pid, prpId, qn);
                    this.prpList.add(pupp);
                    if (this.qn2PRP.containsKey(qn)) {
                        this.qn2PRP.get(qn).add(pupp);
                    } else {
                        ArrayList<PortalURLPublicParameter> s = new ArrayList<PortalURLPublicParameter>();
                        s.add(pupp);
                        this.qn2PRP.put(qn, s);
                        this.qnList.add(qn);
                    }
                    if (!this.isTrace) continue;
                    dbgstr.append("\n      Added PRP for window = " + pid + " QName = " + qn.toString() + ", ID = " + prpId);
                }
            }
            catch (Exception e) {
                if (pad == null) {
                    this.LOGGER.error("Could not get portlet app for: " + cxtpa);
                    continue;
                }
                this.LOGGER.error("Could not get portlet definition for: " + portletName);
            }
        }
        if (this.isTrace) {
            dbgstr.append("\nOn page " + paco.getName() + " there are " + this.prpList.size() + " PRPs divided into " + this.qnList.size() + " groups with sizes: ");
            String prefix = "";
            for (List<PortalURLPublicParameter> lp : this.qn2PRP.values()) {
                dbgstr.append(prefix + lp.size());
                prefix = ", ";
            }
            this.LOGGER.trace(dbgstr.toString());
        }
    }

    private PublicRenderParameterQNameMapper() {
    }

    @Override
    public List<PortalURLPublicParameter> getPublicParameterGroup(int index) {
        ArrayList<PortalURLPublicParameter> oprps = new ArrayList<PortalURLPublicParameter>();
        QName qn = this.qnList.get(index);
        for (PortalURLPublicParameter prp : this.qn2PRP.get(qn)) {
            PortalURLPublicParameter p = prp.clone();
            String[] vals = prp.getValues() == null ? null : (String[])prp.getValues().clone();
            p.setValues(vals);
            oprps.add(p);
        }
        if (this.isTrace) {
            this.LOGGER.trace("For index: " + index + ", QName = " + qn + ", group size = " + oprps.size());
        }
        return oprps;
    }

    @Override
    public int getNumberOfGroups() {
        return this.qnList.size();
    }

    @Override
    public int getIndex(PortalURLPublicParameter prp) {
        int ind = this.qnList.indexOf(prp.getQName());
        if (ind < 0 && this.isTrace) {
            this.LOGGER.trace("PRP Qname " + prp.getQName() + " not found in " + this.qnList.toString());
        }
        return ind;
    }

    @Override
    public int getIndex(String windowId, String identifier) {
        PortalURLPublicParameter tmpPRP = new PortalURLPublicParameter(windowId, identifier, null);
        int ind = this.prpList.indexOf(tmpPRP);
        if (ind < 0) {
            if (this.isTrace) {
                this.LOGGER.trace("Public render parameter with window ID = " + windowId + ", ID = " + identifier + " could not be found.");
            }
        } else {
            QName qn = this.prpList.get(ind).getQName();
            ind = this.qnList.indexOf(qn);
        }
        return ind;
    }

    @Override
    public int getIndex(QName qname) {
        return this.qnList.indexOf(qname);
    }

    @Override
    public void setValues(int index, String[] values) {
        List<PortalURLPublicParameter> oprps = this.qn2PRP.get(this.qnList.get(index));
        for (PortalURLPublicParameter prp : oprps) {
            prp.setValues((String[])values.clone());
        }
    }

    @Override
    public String[] getValues(int index) {
        String[] vals = null;
        List<PortalURLPublicParameter> oprps = this.qn2PRP.get(this.qnList.get(index));
        if (!oprps.get(0).isRemoved()) {
            vals = (String[])oprps.get(0).getValues().clone();
        }
        return vals;
    }

    @Override
    public void setRemoved(int index, boolean removed) {
        List<PortalURLPublicParameter> oprps = this.qn2PRP.get(this.qnList.get(index));
        for (PortalURLPublicParameter prp : oprps) {
            prp.setRemoved(removed);
        }
    }

    @Override
    public boolean getRemoved(int index) {
        List<PortalURLPublicParameter> oprps = this.qn2PRP.get(this.qnList.get(index));
        return oprps.get(0).isRemoved();
    }

    @Override
    public List<Integer> getActiveIndexes() {
        ArrayList<Integer> inds = new ArrayList<Integer>();
        for (QName qn : this.qnList) {
            List<PortalURLPublicParameter> oprps = this.qn2PRP.get(qn);
            if (oprps.get(0).isRemoved()) continue;
            inds.add(this.qnList.indexOf(qn));
        }
        return inds;
    }

    @Override
    public PublicRenderParameterQNameMapper clone() {
        PublicRenderParameterQNameMapper prpm = new PublicRenderParameterQNameMapper();
        StringBuilder dbgstr = new StringBuilder("Cloning QNames: ");
        String prefix = "";
        for (QName qn : this.qnList) {
            prpm.qnList.add(qn);
            prpm.qn2PRP.put(qn, new ArrayList());
            dbgstr.append(prefix + qn.toString());
            prefix = ", ";
        }
        dbgstr.append(" / window IDs: ");
        prefix = "";
        for (PortalURLPublicParameter prp : this.prpList) {
            PortalURLPublicParameter newPrp = prp.clone();
            prpm.prpList.add(newPrp);
            prpm.qn2PRP.get(newPrp.getQName()).add(newPrp);
            dbgstr.append(prefix + prp.getWindowId());
            prefix = ", ";
        }
        if (this.isTrace) {
            // empty if block
        }
        return prpm;
    }

    @Override
    public List<PortalURLPublicParameter> getPRPsForWindow(String wid, boolean onlyActive) {
        ArrayList<PortalURLPublicParameter> prps = new ArrayList<PortalURLPublicParameter>();
        StringBuilder dbgstr = new StringBuilder("Names: ");
        String prefix = "";
        block0: for (int ii = 0; ii < this.qnList.size(); ++ii) {
            for (PortalURLPublicParameter prp : this.qn2PRP.get(this.qnList.get(ii))) {
                if (!prp.getWindowId().equals(wid)) continue;
                if ((!onlyActive || prp.isRemoved()) && onlyActive) continue block0;
                prps.add(prp);
                dbgstr.append(prefix + prp.getName());
                prefix = ", ";
                continue block0;
            }
        }
        if (this.isTrace) {
            this.LOGGER.trace("For window " + wid + " there are " + prps.size() + " parameters. " + dbgstr.toString());
        }
        return prps;
    }
}

