/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.tags;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.tags.PortletTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletTitleTag
extends TagSupport {
    private static final long serialVersionUID = 3120612251049604115L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletTitleTag.class);

    public int doStartTag() throws JspException {
        PortletTag parentTag = (PortletTag)TagSupport.findAncestorWithClass((Tag)this, PortletTag.class);
        if (parentTag == null) {
            throw new JspException("Portlet title tag may only reside within a pluto:portlet tag.");
        }
        try {
            Map titles = (Map)this.pageContext.getRequest().getAttribute("org.apache.pluto.driver.DynamicPortletTitle");
            String portletId = parentTag.getEvaluatedPortletId();
            String title = null;
            if (titles != null) {
                title = (String)titles.get(portletId);
            }
            if (title == null) {
                PortletWindowConfig windowConfig;
                block8: {
                    windowConfig = PortletWindowConfig.fromId(portletId);
                    try {
                        ServletContext servletContext = this.pageContext.getServletContext();
                        DriverConfiguration driverConfig = (DriverConfiguration)servletContext.getAttribute("driverConfig");
                        PortletConfig config = driverConfig.getPortletConfig(portletId);
                        ServletRequest request = this.pageContext.getRequest();
                        Locale defaultLocale = request.getLocale();
                        ResourceBundle bundle = config.getResourceBundle(defaultLocale);
                        title = bundle.getString("javax.portlet.title");
                    }
                    catch (Throwable th) {
                        if (!LOG.isDebugEnabled()) break block8;
                        StringBuilder txt = new StringBuilder(128);
                        txt.append("Could not obtain title for: " + windowConfig.getPortletName() + "\n");
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        th.printStackTrace(pw);
                        pw.flush();
                        txt.append(sw.toString());
                        LOG.warn(txt.toString());
                    }
                }
                if (title == null) {
                    title = "[ " + windowConfig.getPortletName() + " ]";
                }
            }
            this.pageContext.getOut().print(title);
        }
        catch (IOException ex) {
            throw new JspException((Throwable)ex);
        }
        return 0;
    }
}

