/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.driver.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.pluto.driver.config.DriverConfiguration;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PublicRenderParameterMapper;
import org.apache.pluto.driver.url.PortalURL;
import org.apache.pluto.driver.url.PortalURLParameter;
import org.apache.pluto.driver.url.PortalURLPublicParameter;
import org.apache.pluto.driver.util.RenderData;

public class PageState {
    private static final String LOG_CLASS = PageState.class.getName();
    private final Logger LOGGER = Logger.getLogger(LOG_CLASS);
    private DriverConfiguration drvrConfig;
    private PageConfig pageConfig;
    private PortalRequestContext portalRC;
    private PortalURL portalUrl;
    private ServletContext servletContext;
    private Map<String, RenderData> renderDataMap;

    public PageState(HttpServletRequest request) {
        this.portalRC = PortalRequestContext.getContext(request);
        this.portalUrl = this.portalRC.getRequestedPortalURL();
        this.drvrConfig = (DriverConfiguration)this.portalRC.getServletContext().getAttribute("driverConfig");
        this.servletContext = this.portalRC.getServletContext();
        this.pageConfig = this.portalUrl.getPageConfig(this.servletContext);
    }

    public PageState(HttpServletRequest request, Map<String, RenderData> renderDataMap) {
        this(request);
        this.renderDataMap = renderDataMap;
    }

    public Collection<PortalURLParameter> getParameters() {
        return this.portalUrl.getParameters();
    }

    public Map<String, String[]> getPublicParameters() {
        HashMap<String, String[]> tmp = new HashMap<String, String[]>();
        PublicRenderParameterMapper prpMapper = this.portalUrl.getPublicRenderParameterMapper();
        if (prpMapper != null) {
            for (int ind : prpMapper.getActiveIndexes()) {
                String name = prpMapper.getPublicParameterGroup(ind).get(0).getName();
                String[] vals = prpMapper.getValues(ind);
                tmp.put(name, vals);
            }
        }
        return tmp;
    }

    public Collection<String> getPortletIds() {
        return this.pageConfig.getPortletIds();
    }

    public String getNameSpace(String portletId) {
        StringBuffer ns = new StringBuffer("Pluto_");
        for (int ii = 0; ii < portletId.length(); ++ii) {
            if (Character.isJavaIdentifierPart(portletId.charAt(ii))) {
                ns.append(portletId.charAt(ii));
                continue;
            }
            ns.append("_");
        }
        ns.append("_");
        return ns.toString();
    }

    public Set<String> getPRPNames(String portletId) {
        HashSet<String> prpnames = new HashSet<String>();
        PortletConfig pc = null;
        try {
            pc = this.drvrConfig.getPortletConfig(portletId);
            Enumeration prps = pc.getPublicRenderParameterNames();
            while (prps.hasMoreElements()) {
                String prp = (String)prps.nextElement();
                prpnames.add(prp);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return prpnames;
    }

    public String getPRPNamesAsString(String portletId) {
        PortletConfig pc = null;
        StringBuffer prpstring = new StringBuffer();
        String sep = "";
        try {
            pc = this.drvrConfig.getPortletConfig(portletId);
            Enumeration prps = pc.getPublicRenderParameterNames();
            while (prps.hasMoreElements()) {
                String prp = (String)prps.nextElement();
                prpstring.append(sep + "\"" + prp + "\"");
                sep = ", ";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return prpstring.toString();
    }

    public String getPortletModesAsString(String portletId) {
        StringBuffer pmstring = new StringBuffer();
        try {
            Set<PortletMode> allowedPMs = this.drvrConfig.getSupportedPortletModes(portletId);
            String sep = "";
            for (PortletMode pm : allowedPMs) {
                pmstring.append(sep + "\"" + pm.toString() + "\"");
                sep = ", ";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pmstring.toString();
    }

    public String getWindowStatesAsString(String portletId) {
        StringBuffer wsstring = new StringBuffer();
        try {
            Set<WindowState> allowedWSs = this.drvrConfig.getSupportedWindowStates(portletId, "text/html");
            String sep = "";
            for (WindowState ws : allowedWSs) {
                wsstring.append(sep + "\"" + ws.toString() + "\"");
                sep = ", ";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return wsstring.toString();
    }

    public String getPortletMode(String portletId) {
        return this.portalUrl.getPortletMode(portletId).toString();
    }

    public String getWindowState(String portletId) {
        return this.portalUrl.getWindowState(portletId).toString();
    }

    public String getUrlBase() {
        StringBuffer ub = new StringBuffer();
        ub.append(this.portalUrl.getServletPath().startsWith("/") ? "" : "/").append(this.portalUrl.getServletPath()).append(this.portalUrl.getRenderPath());
        return ub.toString();
    }

    public String toJSONString() {
        StringBuffer json = new StringBuffer(1024);
        json.append("{\"portlets\" : {\n");
        Collection<PortalURLParameter> pups = this.getParameters();
        Map<String, String[]> pubparms = this.getPublicParameters();
        PublicRenderParameterMapper mapper = this.portalUrl.getPublicRenderParameterMapper();
        int numGroups = mapper.getNumberOfGroups();
        boolean sep = false;
        for (String pid : this.getPortletIds()) {
            String c2;
            if (sep) {
                json.append(",\n");
            }
            sep = true;
            json.append("   \"" + this.getNameSpace(pid) + "\" : {\n");
            json.append("      \"state\" : {\n");
            json.append("         \"parameters\" : {\n");
            String c1 = "            \"";
            for (PortalURLParameter pup : pups) {
                if (!pup.getWindowId().equals(pid)) continue;
                json.append(c1 + pup.getName() + "\" : [");
                c2 = "";
                for (String val : pup.getValues()) {
                    json.append(c2 + " \"" + val + "\"");
                    c2 = ",";
                }
                json.append("]");
                c1 = ",\n            \"";
            }
            for (PortalURLPublicParameter prp : mapper.getPRPsForWindow(pid, true)) {
                json.append(c1 + prp.getName() + "\" : [");
                c2 = "";
                for (String val : prp.getValues()) {
                    json.append(c2 + " \"" + val + "\"");
                    c2 = ",";
                }
                json.append("]");
                c1 = ",\n            \"";
            }
            json.append("         }, \n");
            json.append("         \"portletMode\" : \"" + this.getPortletMode(pid) + "\", \n");
            json.append("         \"windowState\" : \"" + this.getWindowState(pid) + "\"\n");
            json.append("      },\n");
            json.append("      \"pubParms\" : {");
            String c22 = "";
            for (PortalURLPublicParameter prp : mapper.getPRPsForWindow(pid, false)) {
                int group = mapper.getIndex(prp);
                json.append(c22);
                json.append("\"");
                json.append(prp.getName());
                json.append("\" : \"");
                json.append(String.valueOf(group));
                json.append("\"");
                c22 = ", ";
            }
            json.append("},\n");
            json.append("      \"allowedPM\" : [" + this.getPortletModesAsString(pid) + "],\n");
            json.append("      \"allowedWS\" : [" + this.getWindowStatesAsString(pid) + "],\n");
            json.append("      \"renderData\" : {\n");
            RenderData renderData = null;
            if (this.renderDataMap != null) {
                renderData = this.renderDataMap.get(pid);
            }
            if (renderData == null) {
                json.append("         \"content\" : null,\n");
                json.append("         \"mimeType\" : \"text/plain\"\n");
            } else {
                json.append("         \"content\" : \"");
                String content = StringEscapeUtils.escapeJson((String)renderData.getContent());
                json.append(content);
                json.append("\",\n");
                json.append("         \"mimeType\" : \"");
                json.append(renderData.getContentType());
                json.append("\"\n");
            }
            json.append("      },\n");
            json.append("      \"urlpid\" : \"" + pid + "\"\n");
            json.append("   }");
        }
        json.append("\n},\n\"prpMap\" : {");
        String sep1 = "";
        for (int ii = 0; ii < mapper.getNumberOfGroups(); ++ii) {
            json.append(sep1).append("\n   \"").append(String.valueOf(ii)).append("\" : {");
            sep1 = ",";
            String sep2 = "";
            for (PortalURLPublicParameter prp : mapper.getPublicParameterGroup(ii)) {
                json.append(sep2).append("\n      \"").append(this.getNameSpace(prp.getWindowId())).append("\" : \"").append(prp.getName()).append("\"");
                sep2 = ", ";
            }
            json.append("   }");
        }
        json.append("\n}}");
        return json.toString();
    }
}

