/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.util.install.file.jetty;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.pluto.util.UtilityException;
import org.apache.pluto.util.install.InstallationConfig;
import org.apache.pluto.util.install.file.FileSystemInstaller;

public class Jetty5FileSystemInstaller
extends FileSystemInstaller {
    @Override
    protected File getEndorsedDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        return new File(installationDirectory, "ext");
    }

    @Override
    protected File getSharedDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        if (new File(config.getInstallationDirectory(), "ext/commons-logging.jar").exists()) {
            Iterator iter = config.getSharedDependencies().iterator();
            while (iter.hasNext()) {
                File dep = (File)iter.next();
                if (!dep.getPath().contains("commons-logging-api")) continue;
                iter.remove();
            }
        }
        return new File(installationDirectory, "ext");
    }

    @Override
    protected File getWebAppDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        return new File(installationDirectory, "webapps");
    }

    protected File getConfigurationDir(InstallationConfig config) {
        File installationDirectory = config.getInstallationDirectory();
        String engine = "Catalina";
        String host = config.getServerConfig().getHost();
        return new File(installationDirectory, "conf/" + engine + "/" + host);
    }

    @Override
    public void uninstall(InstallationConfig config) {
    }

    public void deploy() {
    }

    @Override
    public boolean isValidInstallationDirectory(File installDir) {
        File serverConfig = new File(installDir, "etc/jetty.xml");
        return serverConfig.exists();
    }

    @Override
    public void install(InstallationConfig config) throws UtilityException {
        File endorsedDir = this.getEndorsedDir(config);
        File sharedDir = this.getSharedDir(config);
        File domainDir = this.getWebAppDir(config);
        domainDir.mkdirs();
        File contextConfigurationDirectory = this.getConfigurationDir(config);
        try {
            this.copyFilesToDirectory(config.getSharedDependencies(), sharedDir);
            for (File portletApp : config.getPortletApplications().values()) {
                FileUtils.copyFileToDirectory((File)portletApp, (File)domainDir);
            }
            FileUtils.copyFileToDirectory((File)config.getPortalApplication(), (File)domainDir);
        }
        catch (IOException io) {
            throw new UtilityException(io);
        }
    }

    private String getPortalApplicationConfig(InstallationConfig config) {
        File domainDir = this.getWebAppDir(config);
        String war = domainDir.getAbsolutePath() + File.separatorChar + config.getPortalApplication().getName();
        String contextPath = config.getPortalContextPath();
        return this.getConfigContents(war, contextPath);
    }

    private String getPortletApplicationConfig(String contextPath, File file) {
        String war = file.getAbsolutePath();
        return this.getConfigContents(war, contextPath);
    }

    @Override
    public void writeConfiguration(InstallationConfig config) {
    }

    private String getConfigContents(String war, String contextPath) {
        return "JettyConfigContents: war=" + war + "contextPath=" + contextPath;
    }
}

