/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.blobstore;

import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Strings;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Supplier;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Provider;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.atmos.AtmosClient;
import org.jclouds.atmos.blobstore.functions.BlobStoreListOptionsToListOptions;
import org.jclouds.atmos.blobstore.functions.BlobToObject;
import org.jclouds.atmos.blobstore.functions.DirectoryEntryListToResourceMetadataList;
import org.jclouds.atmos.blobstore.functions.ObjectToBlob;
import org.jclouds.atmos.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.atmos.options.ListOptions;
import org.jclouds.atmos.options.PutOptions;
import org.jclouds.atmos.util.AtmosUtils;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseBlobStore;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.crypto.Crypto;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.jclouds.io.PayloadSlicer;

@Singleton
public class AtmosBlobStore
extends BaseBlobStore {
    private final AtmosClient sync;
    private final ObjectToBlob object2Blob;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToObject blob2Object;
    private final BlobStoreListOptionsToListOptions container2ContainerListOptions;
    private final DirectoryEntryListToResourceMetadataList container2ResourceList;
    private final Crypto crypto;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;
    private final LoadingCache<String, Boolean> isPublic;

    @Inject
    AtmosBlobStore(BlobStoreContext context, BlobUtils blobUtils, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, PayloadSlicer slicer, AtmosClient sync, ObjectToBlob object2Blob, ObjectToBlobMetadata object2BlobMd, BlobToObject blob2Object, BlobStoreListOptionsToListOptions container2ContainerListOptions, DirectoryEntryListToResourceMetadataList container2ResourceList, Crypto crypto, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider, LoadingCache<String, Boolean> isPublic) {
        super(context, blobUtils, defaultLocation, locations, slicer);
        this.blob2ObjectGetOptions = Preconditions.checkNotNull(blob2ObjectGetOptions, "blob2ObjectGetOptions");
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.container2ContainerListOptions = Preconditions.checkNotNull(container2ContainerListOptions, "container2ContainerListOptions");
        this.container2ResourceList = Preconditions.checkNotNull(container2ResourceList, "container2ResourceList");
        this.object2Blob = Preconditions.checkNotNull(object2Blob, "object2Blob");
        this.blob2Object = Preconditions.checkNotNull(blob2Object, "blob2Object");
        this.object2BlobMd = Preconditions.checkNotNull(object2BlobMd, "object2BlobMd");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
        this.fetchBlobMetadataProvider = Preconditions.checkNotNull(fetchBlobMetadataProvider, "fetchBlobMetadataProvider");
        this.isPublic = Preconditions.checkNotNull(isPublic, "isPublic");
    }

    @Override
    public BlobMetadata blobMetadata(String container, String key) {
        return this.object2BlobMd.apply(this.sync.headFile(container + "/" + key));
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deletePath(container + "/");
        return !this.sync.pathExists(container + "/");
    }

    @Override
    public boolean createContainerInLocation(Location location, String container) {
        return this.sync.createDirectory(container, new PutOptions[0]) != null;
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        if (this.sync.isPublic(container)) {
            return ContainerAccess.PUBLIC_READ;
        }
        return ContainerAccess.PRIVATE;
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        PutOptions options = new PutOptions();
        if (access == ContainerAccess.PUBLIC_READ) {
            options.publicRead();
        } else {
            options.publicNone();
        }
        this.sync.setGroupAcl(container, options);
    }

    @Override
    public void createDirectory(String container, String directory) {
        this.sync.createDirectory(container + "/" + directory, new PutOptions[0]);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.removeBlob(containerName, directory + "/");
    }

    @Override
    public boolean containerExists(String container) {
        return this.sync.pathExists(container + "/");
    }

    @Override
    public boolean directoryExists(String container, String directory) {
        return this.sync.pathExists(container + "/" + directory + "/");
    }

    @Override
    public boolean blobExists(String container, String key) {
        return this.sync.pathExists(container + "/" + key);
    }

    @Override
    public Blob getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        return this.object2Blob.apply(this.sync.readFile(container + "/" + key, httpOptions));
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        return this.container2ResourceList.apply(this.sync.listDirectories(new ListOptions[0]));
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
        if (!Strings.nullToEmpty(options.getDelimiter()).equals("/") && !Strings.isNullOrEmpty(options.getPrefix())) {
            throw new IllegalArgumentException("Atmos can only list via prefix if delimiter is / and the prefix matches an existing directory");
        }
        container = AtmosUtils.adjustContainerIfDirOptionPresent(container, options);
        if (!Strings.isNullOrEmpty(options.getPrefix())) {
            container = container + "/" + options.getPrefix();
        }
        ListOptions nativeOptions = this.container2ContainerListOptions.apply(options);
        PageSet<? extends StorageMetadata> list = this.container2ResourceList.apply(this.sync.listDirectory(container, nativeOptions));
        return options.isDetailed() ? this.fetchBlobMetadataProvider.get().setContainerName(container).apply(list) : list;
    }

    @Override
    public String putBlob(String container, Blob blob) {
        return this.putBlob(container, blob, org.jclouds.blobstore.options.PutOptions.NONE);
    }

    @Override
    public String putBlob(String container, Blob blob, org.jclouds.blobstore.options.PutOptions options) {
        if (options.isMultipart()) {
            throw new UnsupportedOperationException("Atmos does not support multipart uploads");
        }
        PutOptions atmosOptions = new PutOptions();
        atmosOptions.publicNone();
        try {
            if (this.isPublic.getUnchecked(container + "/").booleanValue()) {
                atmosOptions.publicRead();
            }
        }
        catch (CacheLoader.InvalidCacheLoadException invalidCacheLoadException) {
            // empty catch block
        }
        if (options.getBlobAccess() == BlobAccess.PUBLIC_READ) {
            atmosOptions.publicRead();
        }
        return AtmosUtils.putBlob(this.sync, this.crypto, this.blob2Object, container, blob, atmosOptions);
    }

    @Override
    public void removeBlob(String container, String key) {
        this.sync.deletePath(container + "/" + key);
    }

    @Override
    public BlobAccess getBlobAccess(String container, String key) {
        if (this.sync.isPublic(container + "/" + key)) {
            return BlobAccess.PUBLIC_READ;
        }
        return BlobAccess.PRIVATE;
    }

    @Override
    public void setBlobAccess(String container, String key, BlobAccess access) {
        PutOptions options = new PutOptions();
        if (access == BlobAccess.PUBLIC_READ) {
            options.publicRead();
        } else {
            options.publicNone();
        }
        this.sync.setGroupAcl(container + "/" + key, options);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            return this.sync.createDirectory(container, PutOptions.Builder.publicRead()) != null;
        }
        return this.createContainerInLocation(location, container);
    }

    @Override
    public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blobMetadata, org.jclouds.blobstore.options.PutOptions options) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public void abortMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public List<MultipartUpload> listMultipartUploads(String container) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public long getMinimumMultipartPartSize() {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public long getMaximumMultipartPartSize() {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public int getMaximumNumberOfParts() {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public InputStream streamBlob(String container, String name) {
        throw new UnsupportedOperationException("Atmos does not support multipart uploads");
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        if (options.ifMatch() != null) {
            throw new UnsupportedOperationException("Atmos does not support ifMatch");
        }
        if (options.ifNoneMatch() != null) {
            throw new UnsupportedOperationException("Atmos does not support ifNoneMatch");
        }
        return super.copyBlob(fromContainer, fromName, toContainer, toName, options);
    }
}

