/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Singleton;
import org.jclouds.azureblob.domain.PublicAccess;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public final class BindPublicAccessToRequest
implements Binder {
    @Inject
    public BindPublicAccessToRequest() {
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkNotNull(request, "request");
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof PublicAccess, "this binder is only valid for PublicAccess");
        PublicAccess access = (PublicAccess)((Object)input);
        switch (access) {
            case PRIVATE: {
                break;
            }
            default: {
                request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("x-ms-blob-public-access", access.name().toLowerCase())).build();
            }
        }
        return request;
    }
}

