/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain;

import org.apache.pulsar.jcloud.shade.com.google.common.base.CaseFormat;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.jclouds.blobstore.domain.Tier;

public enum AccessTier {
    HOT(Tier.STANDARD),
    COOL(Tier.INFREQUENT),
    ARCHIVE(Tier.ARCHIVE);

    private final Tier tier;

    private AccessTier(Tier tier) {
        this.tier = Preconditions.checkNotNull(tier);
    }

    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static AccessTier fromValue(String tier) {
        return AccessTier.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, Preconditions.checkNotNull(tier, "tier")));
    }

    public static AccessTier fromTier(Tier tier) {
        switch (tier) {
            case STANDARD: {
                return HOT;
            }
            case INFREQUENT: {
                return COOL;
            }
            case ARCHIVE: {
                return ARCHIVE;
            }
        }
        throw new IllegalArgumentException("invalid tier: " + (Object)((Object)tier));
    }

    public Tier toTier() {
        return this.tier;
    }
}

