/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Maps;
import org.jclouds.azureblob.domain.AccessTier;
import org.jclouds.azureblob.domain.BlobProperties;
import org.jclouds.azureblob.domain.BlobType;
import org.jclouds.azureblob.domain.LeaseStatus;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.payloads.BaseImmutableContentMetadata;
import org.jclouds.javax.annotation.Nullable;

public class BlobPropertiesImpl
implements BlobProperties {
    private final BlobType type;
    private final AccessTier tier;
    private final String name;
    private final String container;
    private final URI url;
    private final Date lastModified;
    private final String eTag;
    private final Map<String, String> metadata = Maps.newLinkedHashMap();
    private final LeaseStatus leaseStatus;
    private final BaseImmutableContentMetadata contentMetadata;

    @Deprecated
    public BlobPropertiesImpl(BlobType type, String name, String container, URI url, @Nullable Date lastModified, @Nullable String eTag, long size, String contentType, @Nullable byte[] contentMD5, @Nullable String contentMetadata, @Nullable String contentLanguage, @Nullable Date currentExpires, LeaseStatus leaseStatus, Map<String, String> metadata) {
        this(type, null, name, container, url, lastModified, eTag, size, contentType, contentMD5, contentMetadata, contentLanguage, currentExpires, leaseStatus, metadata);
    }

    public BlobPropertiesImpl(BlobType type, @Nullable AccessTier tier, String name, String container, URI url, @Nullable Date lastModified, @Nullable String eTag, long size, String contentType, @Nullable byte[] contentMD5, @Nullable String contentMetadata, @Nullable String contentLanguage, @Nullable Date currentExpires, LeaseStatus leaseStatus, Map<String, String> metadata) {
        this.type = Preconditions.checkNotNull(type, "type");
        this.tier = tier;
        this.leaseStatus = Preconditions.checkNotNull(leaseStatus, "leaseStatus");
        this.name = Preconditions.checkNotNull(name, "name");
        this.container = Preconditions.checkNotNull(container, "container");
        this.url = Preconditions.checkNotNull(url, "url");
        this.lastModified = lastModified;
        this.eTag = eTag;
        this.contentMetadata = new BaseImmutableContentMetadata(contentType, size, contentMD5, null, contentLanguage, contentMetadata, currentExpires);
        this.metadata.putAll(Preconditions.checkNotNull(metadata, "metadata"));
    }

    @Override
    public BlobType getType() {
        return this.type;
    }

    @Override
    public AccessTier getTier() {
        return this.tier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public int compareTo(BlobProperties o) {
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    public URI getUrl() {
        return this.url;
    }

    @Override
    public LeaseStatus getLeaseStatus() {
        return this.leaseStatus;
    }

    @Override
    public ContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlobPropertiesImpl other = (BlobPropertiesImpl)obj;
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return String.format("[name=%s, container=%s, url=%s, contentMetadata=%s, eTag=%s, lastModified=%s, leaseStatus=%s, metadata=%s, type=%s]", new Object[]{this.name, this.container, this.url, this.contentMetadata, this.eTag, this.lastModified, this.leaseStatus, this.metadata, this.type});
    }
}

