/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import java.util.Iterator;
import org.apache.pulsar.jcloud.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.AbstractIterator;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.ListAllOptions;
import org.jclouds.blobstore.options.ListContainerOptions;

public class BlobStores {
    @Beta
    public static Iterable<StorageMetadata> listAll(BlobStore blobStore, String container, ListContainerOptions containerOptions) {
        return BlobStores.listAll(blobStore, container, containerOptions, ListAllOptions.NONE);
    }

    @Beta
    public static Iterable<StorageMetadata> listAll(final BlobStore blobStore, final String container, final ListContainerOptions containerOptions, ListAllOptions listAllOptions) {
        String firstMarker;
        PageSet<? extends StorageMetadata> firstList;
        final boolean eager = listAllOptions.isEager();
        if (eager) {
            firstList = blobStore.list(container, containerOptions);
            firstMarker = firstList.getNextMarker();
        } else {
            firstList = null;
            firstMarker = null;
        }
        return new Iterable<StorageMetadata>(){

            @Override
            public Iterator<StorageMetadata> iterator() {
                return new AbstractIterator<StorageMetadata>(){
                    private Iterator<? extends StorageMetadata> iterator;
                    private String marker;

                    @Override
                    public StorageMetadata computeNext() {
                        while (true) {
                            if (this.iterator == null) {
                                PageSet<? extends StorageMetadata> list;
                                if (eager && this.marker == null) {
                                    list = firstList;
                                    this.marker = firstMarker;
                                } else {
                                    ListContainerOptions nextOptions = this.marker == null ? containerOptions : containerOptions.clone().afterMarker(this.marker);
                                    list = blobStore.list(container, nextOptions);
                                    this.marker = list.getNextMarker();
                                }
                                this.iterator = list.iterator();
                            }
                            if (this.iterator.hasNext()) {
                                return this.iterator.next();
                            }
                            if (this.marker == null) {
                                return (StorageMetadata)this.endOfData();
                            }
                            this.iterator = null;
                        }
                    }
                };
            }
        };
    }
}

