/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import java.util.Map;
import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableMap;
import org.apache.pulsar.jcloud.shade.jakarta.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateUserOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String tenant;
    private String password;
    private String email;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CreateUserOptions) {
            CreateUserOptions other = (CreateUserOptions)CreateUserOptions.class.cast(object);
            return Objects.equal(this.tenant, other.tenant) && Objects.equal(this.password, other.password) && Objects.equal(this.email, other.email) && Objects.equal(this.enabled, other.enabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.tenant, this.password, this.email, this.enabled);
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper("").omitNullValues();
        toString.add("tenant", this.tenant);
        toString.add("password", this.password);
        toString.add("email", this.email);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest user = new ServerRequest(Preconditions.checkNotNull(postParams.get("name"), "name parameter not present").toString(), Preconditions.checkNotNull(postParams.get("password"), "password parameter not present").toString());
        if (this.email != null) {
            user.email = this.email;
        }
        if (this.password != null) {
            user.password = this.password;
        }
        if (this.tenant != null) {
            user.tenantId = this.tenant;
        }
        user.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of("user", user));
    }

    public String getTenant() {
        return this.tenant;
    }

    public CreateUserOptions tenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public CreateUserOptions email(String email) {
        this.email = email;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public CreateUserOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateUserOptions tenant(String tenant) {
            CreateUserOptions options = new CreateUserOptions();
            return options.tenant(tenant);
        }

        public static CreateUserOptions email(String email) {
            CreateUserOptions options = new CreateUserOptions();
            return options.email(email);
        }

        public static CreateUserOptions enabled(boolean enabled) {
            CreateUserOptions options = new CreateUserOptions();
            return options.enabled(enabled);
        }
    }

    static class ServerRequest {
        final String name;
        String tenantId;
        String password;
        String email;
        boolean enabled;

        private ServerRequest(String name, String password) {
            this.name = name;
            this.password = password;
        }
    }
}

