/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Function;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.ImmutableSet;
import org.apache.pulsar.jcloud.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.jcloud.shade.com.google.common.reflect.TypeToken;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.osgi.ProviderRegistry;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;
import org.jclouds.reflect.Reflection2;

public class Providers {
    public static Function<ProviderMetadata, String> idFunction() {
        return IdFunction.INSTANCE;
    }

    public static Function<ProviderMetadata, ApiMetadata> apiMetadataFunction() {
        return new ApiMetadataFunction();
    }

    public static Iterable<ProviderMetadata> fromServiceLoader() {
        return ServiceLoader.load(ProviderMetadata.class);
    }

    public static Iterable<ProviderMetadata> all() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(Providers.fromServiceLoader())).addAll(ProviderRegistry.fromRegistry())).build();
    }

    public static ProviderMetadata withId(String id) throws NoSuchElementException {
        return Iterables.find(Providers.all(), ProviderPredicates.id(id));
    }

    public static Iterable<ProviderMetadata> viewableAs(TypeToken<? extends View> viewableAs) {
        return Iterables.filter(Providers.all(), ProviderPredicates.viewableAs(viewableAs));
    }

    public static Iterable<ProviderMetadata> viewableAs(Class<? extends View> viewableAs) {
        return Iterables.filter(Providers.all(), ProviderPredicates.viewableAs(Reflection2.typeToken(viewableAs)));
    }

    public static Iterable<ProviderMetadata> apiMetadataAssignableFrom(TypeToken<? extends ApiMetadata> api) {
        Preconditions.checkNotNull(api, "api must be defined");
        return Iterables.filter(Providers.all(), ProviderPredicates.apiMetadataAssignableFrom(api));
    }

    public static <C extends Context> Iterable<ProviderMetadata> contextAssignableFrom(TypeToken<? extends Context> context) {
        Preconditions.checkNotNull(context, "context must be defined");
        return Iterables.filter(Providers.all(), new ProviderPredicates.ContextAssignableFrom(context));
    }

    public static Iterable<ProviderMetadata> boundedByIso3166Code(String iso3166Code) {
        return Iterables.filter(Providers.all(), ProviderPredicates.boundedByIso3166Code(iso3166Code));
    }

    public static Iterable<ProviderMetadata> boundedByIso3166Code(String iso3166Code, TypeToken<? extends View> viewableAs) {
        return Iterables.filter(Providers.all(), Predicates.and(ProviderPredicates.boundedByIso3166Code(iso3166Code), ProviderPredicates.viewableAs(viewableAs)));
    }

    public static Iterable<ProviderMetadata> boundedByIso3166Code(String iso3166Code, Class<? extends View> viewableAs) {
        return Providers.boundedByIso3166Code(iso3166Code, Reflection2.typeToken(viewableAs));
    }

    public static Iterable<ProviderMetadata> collocatedWith(ProviderMetadata providerMetadata) {
        return Iterables.filter(Providers.all(), ProviderPredicates.intersectingIso3166Code(providerMetadata));
    }

    public static Iterable<ProviderMetadata> collocatedWith(ProviderMetadata providerMetadata, TypeToken<? extends View> viewableAs) {
        return Iterables.filter(Providers.all(), Predicates.and(ProviderPredicates.intersectingIso3166Code(providerMetadata), ProviderPredicates.viewableAs(viewableAs)));
    }

    public static Iterable<ProviderMetadata> collocatedWith(ProviderMetadata providerMetadata, Class<? extends View> viewableAs) {
        return Providers.collocatedWith(providerMetadata, Reflection2.typeToken(viewableAs));
    }

    public static class ApiMetadataFunction
    implements Function<ProviderMetadata, ApiMetadata> {
        @Override
        public ApiMetadata apply(ProviderMetadata input) {
            return input.getApiMetadata();
        }
    }

    public static enum IdFunction implements Function<ProviderMetadata, String>
    {
        INSTANCE;


        @Override
        public String apply(ProviderMetadata input) {
            return input.getId();
        }
    }
}

