/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudidentity.v2_0.domain;

import org.apache.pulsar.jcloud.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Objects;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.jclouds.openstack.keystone.auth.config.CredentialType;

@CredentialType(value="RAX-KSKEY:apiKeyCredentials")
public class ApiKeyCredentials {
    protected final String username;
    protected final String apiKey;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ApiKeyCredentials.builder().fromApiKeyCredentials(this);
    }

    public static ApiKeyCredentials createWithUsernameAndApiKey(String username, String apiKey) {
        return ApiKeyCredentials.builder().apiKey(apiKey).username(username).build();
    }

    protected ApiKeyCredentials(String username, String apiKey) {
        this.username = Preconditions.checkNotNull(username, "username");
        this.apiKey = Preconditions.checkNotNull(apiKey, "apiKey");
    }

    public String getUsername() {
        return this.username;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ApiKeyCredentials) {
            ApiKeyCredentials other = (ApiKeyCredentials)ApiKeyCredentials.class.cast(object);
            return Objects.equal(this.username, other.username) && Objects.equal(this.apiKey, other.apiKey);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.username, this.apiKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper("").add("username", this.username).add("apiKey", this.apiKey).toString();
    }

    public static class Builder {
        protected String username;
        protected String apiKey;

        protected Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public ApiKeyCredentials build() {
            return new ApiKeyCredentials(this.username, this.apiKey);
        }

        public Builder fromApiKeyCredentials(ApiKeyCredentials from) {
            return this.username(from.getUsername()).apiKey(from.getApiKey());
        }
    }
}

