/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import org.apache.pulsar.jcloud.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Predicates;
import org.apache.pulsar.jcloud.shade.com.google.common.base.Throwables;
import org.jclouds.Fallback;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Throwables2;

public final class S3Fallbacks {
    private S3Fallbacks() {
    }

    public static final class TrueOn404OrNotFoundFalseOnIllegalState
    implements Fallback<Boolean> {
        @Override
        public Boolean createOrPropagate(Throwable t) throws Exception {
            if (Throwables2.getFirstThrowableOfType(Preconditions.checkNotNull(t, "throwable"), IllegalStateException.class) != null) {
                return false;
            }
            if (Throwables2.getFirstThrowableOfType(t, ContainerNotFoundException.class) != null) {
                return true;
            }
            if (HttpUtils.returnValueOnCodeOrNull(t, true, Predicates.equalTo(404)) != null) {
                return true;
            }
            throw Throwables.propagate(t);
        }
    }
}

