/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.util.concurrent.atomic.AtomicLong;
import javax.naming.AuthenticationException;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.PulsarSaslServer;
import org.apache.pulsar.broker.authentication.SaslAuthenticationDataSource;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslAuthenticationState
implements AuthenticationState {
    private static final Logger log = LoggerFactory.getLogger(SaslAuthenticationState.class);
    private final long stateId = stateIdGenerator.incrementAndGet();
    private static final AtomicLong stateIdGenerator = new AtomicLong(0L);
    private final SaslAuthenticationDataSource authenticationDataSource;
    private PulsarSaslServer pulsarSaslServer;

    public SaslAuthenticationState(PulsarSaslServer server) {
        this.authenticationDataSource = new SaslAuthenticationDataSource(server);
        this.pulsarSaslServer = server;
    }

    public String getAuthRole() {
        return this.pulsarSaslServer.getAuthorizationID();
    }

    public AuthenticationDataSource getAuthDataSource() {
        return this.authenticationDataSource;
    }

    public boolean isComplete() {
        return this.pulsarSaslServer.isComplete();
    }

    public AuthData authenticate(AuthData authData) throws AuthenticationException {
        return this.pulsarSaslServer.response(authData);
    }

    public long getStateId() {
        return this.stateId;
    }
}

