/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.filter;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.broker.loadbalance.extensions.policies.IsolationPoliciesHelper;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerIsolationPoliciesFilter
implements BrokerFilter {
    private static final Logger log = LoggerFactory.getLogger(BrokerIsolationPoliciesFilter.class);
    public static final String FILTER_NAME = "broker_isolation_policies_filter";
    private IsolationPoliciesHelper isolationPoliciesHelper;

    public BrokerIsolationPoliciesFilter(IsolationPoliciesHelper helper) {
        this.isolationPoliciesHelper = helper;
    }

    @Override
    public String name() {
        return FILTER_NAME;
    }

    @Override
    public CompletableFuture<Map<String, BrokerLookupData>> filterAsync(Map<String, BrokerLookupData> availableBrokers, ServiceUnitId serviceUnit, LoadManagerContext context) {
        return this.isolationPoliciesHelper.applyIsolationPoliciesAsync(availableBrokers, serviceUnit).thenApply(brokerCandidateCache -> {
            availableBrokers.keySet().retainAll((Collection<?>)brokerCandidateCache);
            return availableBrokers;
        });
    }
}

