/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.apache.pulsar.common.util.SecurityUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerProxy
extends X509ExtendedKeyManager {
    private static final Logger log = LoggerFactory.getLogger(KeyManagerProxy.class);
    private static final char[] KEYSTORE_PASSWORD = "secret".toCharArray();
    private volatile X509ExtendedKeyManager keyManager;
    private FileModifiedTimeUpdater certFile;
    private FileModifiedTimeUpdater keyFile;

    public KeyManagerProxy(String certFilePath, String keyFilePath, int refreshDurationSec, ScheduledExecutorService executor) {
        this.certFile = new FileModifiedTimeUpdater(certFilePath);
        this.keyFile = new FileModifiedTimeUpdater(keyFilePath);
        try {
            this.updateKeyManager();
        }
        catch (CertificateException e) {
            log.warn("Failed to load cert {}", (Object)this.certFile, (Object)e);
            throw new IllegalArgumentException(e);
        }
        catch (KeyStoreException e) {
            log.warn("Failed to load key {}", (Object)this.keyFile, (Object)e);
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException e) {
            log.warn("Failed to update key Manager", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        executor.scheduleWithFixedDelay(() -> this.updateKeyManagerSafely(), refreshDurationSec, refreshDurationSec, TimeUnit.SECONDS);
    }

    private void updateKeyManagerSafely() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("refreshing key manager for {} {}", (Object)this.certFile.getFileName(), (Object)this.keyFile.getFileName());
            }
            this.updateKeyManager();
        }
        catch (Exception e) {
            log.warn("Failed to update key Manager for {}, {}", new Object[]{this.certFile.getFileName(), this.keyFile.getFileName(), e});
        }
    }

    private void updateKeyManager() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore;
        if (this.keyManager != null && !this.certFile.checkAndRefresh() && !this.keyFile.checkAndRefresh()) {
            return;
        }
        try (FileInputStream publicCertStream = new FileInputStream(this.certFile.getFileName());){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            List<Certificate> certificateList = cf.generateCertificates(publicCertStream).stream().map(o -> (X509Certificate)o).collect(Collectors.toList());
            keyStore = KeyStore.getInstance("JKS");
            String alias = ((X509Certificate)certificateList.get(0)).getSubjectX500Principal().getName();
            PrivateKey privateKey = SecurityUtility.loadPrivateKeyFromPemFile(this.keyFile.getFileName());
            keyStore.load(null);
            keyStore.setKeyEntry(alias, privateKey, KEYSTORE_PASSWORD, certificateList.toArray(new Certificate[0]));
        }
        catch (IOException | KeyManagementException e) {
            throw new IllegalArgumentException(e);
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, KEYSTORE_PASSWORD);
        this.keyManager = (X509ExtendedKeyManager)keyManagerFactory.getKeyManagers()[0];
    }

    @Override
    public String[] getClientAliases(String s2, Principal[] principals) {
        return this.keyManager.getClientAliases(s2, principals);
    }

    @Override
    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        return this.keyManager.chooseClientAlias(strings, principals, socket);
    }

    @Override
    public String[] getServerAliases(String s2, Principal[] principals) {
        return this.keyManager.getServerAliases(s2, principals);
    }

    @Override
    public String chooseServerAlias(String s2, Principal[] principals, Socket socket) {
        return this.keyManager.chooseServerAlias(s2, principals, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String s2) {
        return this.keyManager.getCertificateChain(s2);
    }

    @Override
    public PrivateKey getPrivateKey(String s2) {
        return this.keyManager.getPrivateKey(s2);
    }

    @Override
    public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
        return this.keyManager.chooseEngineClientAlias(keyType, issuers, engine);
    }

    @Override
    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        return this.keyManager.chooseEngineServerAlias(keyType, issuers, engine);
    }
}

