/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.FutureUtil;

public interface AuthorizationProvider
extends Closeable {
    default public CompletableFuture<Boolean> isSuperUser(String role, AuthenticationDataSource authenticationData, ServiceConfiguration serviceConfiguration) {
        Set<String> superUserRoles = serviceConfiguration.getSuperUserRoles();
        return CompletableFuture.completedFuture(role != null && superUserRoles.contains(role));
    }

    default public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        return CompletableFuture.completedFuture(role != null && tenantInfo.getAdminRoles() != null && tenantInfo.getAdminRoles().contains(role));
    }

    default public void initialize(ServiceConfiguration conf, PulsarResources pulsarResources) throws IOException {
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> canConsumeAsync(TopicName var1, String var2, AuthenticationDataSource var3, String var4);

    public CompletableFuture<Boolean> canLookupAsync(TopicName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName var1, String var2, AuthenticationDataSource var3);

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName var1, Set<AuthAction> var2, String var3, String var4);

    default public CompletableFuture<Void> revokePermissionAsync(NamespaceName namespace, String role) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("revokePermissionAsync on namespace %s is not supported by the Authorization", namespace)));
    }

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName var1, String var2, Set<String> var3, String var4);

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName var1, String var2, String var3, String var4);

    public CompletableFuture<Void> grantPermissionAsync(TopicName var1, Set<AuthAction> var2, String var3, String var4);

    default public CompletableFuture<Void> revokePermissionAsync(TopicName topicName, String role) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("revokePermissionAsync on topicName %s is not supported by the Authorization", topicName)));
    }

    default public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("allowTenantOperation(%s) on tenant %s is not supported by the Authorization provider you are using.", operation.toString(), tenantName)));
    }

    default public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture(new IllegalStateException("NamespaceOperation [" + operation.name() + "] is not supported by the Authorization provider you are using."));
    }

    default public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture(new IllegalStateException("NamespacePolicyOperation  [" + policy.name() + "/" + operation.name() + "] is not supported by is not supported by the Authorization provider you are using."));
    }

    default public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topic, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture(new IllegalStateException("TopicOperation [" + operation.name() + "] is not supported by the Authorizationprovider you are using."));
    }

    default public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topic, String role, PolicyName policy, PolicyOperation operation, AuthenticationDataSource authData) {
        return FutureUtil.failedFuture(new IllegalStateException("TopicPolicyOperation [" + policy.name() + "/" + operation.name() + "] is not supported by the Authorization provider you are using."));
    }

    default public CompletableFuture<Void> removePermissionsAsync(TopicName topicName) {
        return CompletableFuture.completedFuture(null);
    }

    default public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(TopicName topicName) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("getPermissionsAsync on topicName %s is not supported by the Authorization", topicName)));
    }

    default public CompletableFuture<Map<String, Set<String>>> getSubscriptionPermissionsAsync(NamespaceName namespaceName) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("getSubscriptionPermissionsAsync on namespace %s is not supported by the Authorization", namespaceName)));
    }

    default public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(NamespaceName namespaceName) {
        return FutureUtil.failedFuture(new IllegalStateException(String.format("getPermissionsAsync on namespaceName %s is not supported by the Authorization", namespaceName)));
    }
}

