/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.admin.NonPersistentTopics;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.base.Preconditions;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.Entity;
import org.apache.pulsar.functions.runtime.shaded.javax.ws.rs.client.WebTarget;

public class NonPersistentTopicsImpl
extends BaseResource
implements NonPersistentTopics {
    private final WebTarget adminNonPersistentTopics;
    private final WebTarget adminV2NonPersistentTopics;

    public NonPersistentTopicsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminNonPersistentTopics = web.path("/admin");
        this.adminV2NonPersistentTopics = web.path("/admin/v2");
    }

    @Override
    public void createPartitionedTopic(String topic, int numPartitions) throws PulsarAdminException {
        this.sync(() -> this.createPartitionedTopicAsync(topic, numPartitions));
    }

    @Override
    public CompletableFuture<Void> createPartitionedTopicAsync(String topic, int numPartitions) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions should be more than 0");
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "partitions");
        return this.asyncPutRequest(path, Entity.entity(Integer.valueOf(numPartitions), "application/json"));
    }

    @Override
    public PartitionedTopicMetadata getPartitionedTopicMetadata(String topic) throws PulsarAdminException {
        return (PartitionedTopicMetadata)this.sync(() -> this.getPartitionedTopicMetadataAsync(topic));
    }

    @Override
    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "partitions");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PartitionedTopicMetadata>(){});
    }

    @Override
    public NonPersistentTopicStats getStats(String topic) throws PulsarAdminException {
        return (NonPersistentTopicStats)this.sync(() -> this.getStatsAsync(topic));
    }

    @Override
    public CompletableFuture<NonPersistentTopicStats> getStatsAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "stats");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<NonPersistentTopicStats>(){});
    }

    @Override
    public PersistentTopicInternalStats getInternalStats(String topic) throws PulsarAdminException {
        return (PersistentTopicInternalStats)this.sync(() -> this.getInternalStatsAsync(topic));
    }

    @Override
    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "internalStats");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PersistentTopicInternalStats>(){});
    }

    @Override
    public void unload(String topic) throws PulsarAdminException {
        this.sync(() -> this.unloadAsync(topic));
    }

    @Override
    public CompletableFuture<Void> unloadAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    @Override
    public List<String> getListInBundle(String namespace, String bundleRange) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListInBundleAsync(namespace, bundleRange));
    }

    @Override
    public CompletableFuture<List<String>> getListInBundleAsync(String namespace, String bundleRange) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath("non-persistent", ns, bundleRange);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    @Override
    public List<String> getList(String namespace) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListAsync(namespace));
    }

    @Override
    public CompletableFuture<List<String>> getListAsync(String namespace) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath("non-persistent", ns, new String[0]);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    private TopicName validateTopic(String topic) {
        return TopicName.get(topic);
    }

    private WebTarget namespacePath(String domain, NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2NonPersistentTopics : this.adminNonPersistentTopics;
        WebTarget namespacePath = base.path(domain).path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2NonPersistentTopics : this.adminNonPersistentTopics;
        WebTarget topicPath = base.path(topic.getRestPath());
        topicPath = WebTargets.addParts(topicPath, parts);
        return topicPath;
    }
}

