/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.client.impl.schema.AvroBaseStructSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.reader.JacksonJsonReader;
import org.apache.pulsar.client.impl.schema.util.SchemaUtil;
import org.apache.pulsar.client.impl.schema.writer.JacksonJsonWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSchema<T>
extends AvroBaseStructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(JSONSchema.class);
    private static final AtomicReference<ObjectMapper> JSON_MAPPER = new AtomicReference<ObjectMapper>(JSONSchema.createObjectMapper());
    private final Class<T> pojo;

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = ObjectMapperFactory.create();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    private static ObjectMapper jsonMapper() {
        return JSON_MAPPER.get();
    }

    private JSONSchema(SchemaInfo schemaInfo, Class<T> pojo, SchemaReader<T> reader, SchemaWriter<T> writer) {
        super(schemaInfo);
        this.pojo = pojo;
        this.setWriter(writer);
        this.setReader(reader);
    }

    public SchemaInfo getBackwardsCompatibleJsonSchemaInfo() {
        SchemaInfoImpl backwardsCompatibleSchemaInfo;
        try {
            ObjectWriter objectWriter = ObjectMapperFactory.getMapperWithIncludeAlways().writer();
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(objectWriter);
            JsonSchema jsonBackwardsCompatibleSchema = schemaGen.generateSchema(this.pojo);
            backwardsCompatibleSchemaInfo = SchemaInfoImpl.builder().name("").properties(this.schemaInfo.getProperties()).type(SchemaType.JSON).schema(objectWriter.writeValueAsBytes(jsonBackwardsCompatibleSchema)).build();
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return backwardsCompatibleSchemaInfo;
    }

    public static <T> JSONSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        SchemaReader reader = schemaDefinition.getSchemaReaderOpt().orElseGet(() -> new JacksonJsonReader(JSONSchema.jsonMapper(), schemaDefinition.getPojo()));
        SchemaWriter writer = schemaDefinition.getSchemaWriterOpt().orElseGet(() -> new JacksonJsonWriter(JSONSchema.jsonMapper()));
        return new JSONSchema<T>(SchemaUtil.parseSchemaInfo(schemaDefinition, SchemaType.JSON), schemaDefinition.getPojo(), reader, writer);
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build());
    }

    public static void clearCaches() {
        JSONSchema.jsonMapper().getTypeFactory().clearCache();
        JSONSchema.replaceSingletonInstance();
    }

    private static void replaceSingletonInstance() {
        JSON_MAPPER.set(JSONSchema.createObjectMapper());
    }
}

