/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pulsar.common.util.Hash;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.primitives.UnsignedBytes;

public class Murmur3_32Hash
implements Hash {
    private static final Murmur3_32Hash instance = new Murmur3_32Hash();
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    private Murmur3_32Hash() {
        this.seed = 0;
    }

    public static Hash getInstance() {
        return instance;
    }

    @Override
    public int makeHash(byte[] b) {
        return this.makeHash0(b) & Integer.MAX_VALUE;
    }

    private int makeHash0(byte[] bytes) {
        int k1;
        int len = bytes.length;
        int reminder = len % 4;
        int h1 = this.seed;
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.remaining() >= 4) {
            k1 = byteBuffer.getInt();
            k1 = this.mixK1(k1);
            h1 = this.mixH1(h1, k1);
        }
        k1 = 0;
        for (int i = 0; i < reminder; ++i) {
            k1 ^= UnsignedBytes.toInt(byteBuffer.get()) << i * 8;
        }
        h1 ^= this.mixK1(k1);
        h1 ^= len;
        h1 = this.fmix(h1);
        return h1;
    }

    private int fmix(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    private int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        return h1 * 5 + -430675100;
    }
}

