/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Collections;
import java.util.List;
import org.apache.pulsar.functions.proto.Function;

public class InstanceConfig {
    private int instanceId;
    private String functionId;
    private String transformFunctionId;
    private String functionVersion;
    private Function.FunctionDetails functionDetails;
    private int maxBufferedTuples;
    private Function.FunctionAuthenticationSpec functionAuthenticationSpec;
    private int port;
    private String clusterName;
    private int maxPendingAsyncRequests = 1000;
    private boolean exposePulsarAdminClientEnabled = false;
    private int metricsPort;
    private List<String> additionalJavaRuntimeArguments = Collections.emptyList();
    private boolean ignoreUnknownConfigFields;

    public String getInstanceName() {
        return "" + this.instanceId;
    }

    public Function.FunctionDetails getFunctionDetails() {
        return this.functionDetails;
    }

    public boolean hasValidMetricsPort() {
        return this.metricsPort > 0 && this.metricsPort < 65536;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public String getFunctionId() {
        return this.functionId;
    }

    public String getTransformFunctionId() {
        return this.transformFunctionId;
    }

    public String getFunctionVersion() {
        return this.functionVersion;
    }

    public int getMaxBufferedTuples() {
        return this.maxBufferedTuples;
    }

    public Function.FunctionAuthenticationSpec getFunctionAuthenticationSpec() {
        return this.functionAuthenticationSpec;
    }

    public int getPort() {
        return this.port;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getMaxPendingAsyncRequests() {
        return this.maxPendingAsyncRequests;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public List<String> getAdditionalJavaRuntimeArguments() {
        return this.additionalJavaRuntimeArguments;
    }

    public boolean isIgnoreUnknownConfigFields() {
        return this.ignoreUnknownConfigFields;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setTransformFunctionId(String transformFunctionId) {
        this.transformFunctionId = transformFunctionId;
    }

    public void setFunctionVersion(String functionVersion) {
        this.functionVersion = functionVersion;
    }

    public void setFunctionDetails(Function.FunctionDetails functionDetails) {
        this.functionDetails = functionDetails;
    }

    public void setMaxBufferedTuples(int maxBufferedTuples) {
        this.maxBufferedTuples = maxBufferedTuples;
    }

    public void setFunctionAuthenticationSpec(Function.FunctionAuthenticationSpec functionAuthenticationSpec) {
        this.functionAuthenticationSpec = functionAuthenticationSpec;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMaxPendingAsyncRequests(int maxPendingAsyncRequests) {
        this.maxPendingAsyncRequests = maxPendingAsyncRequests;
    }

    public void setExposePulsarAdminClientEnabled(boolean exposePulsarAdminClientEnabled) {
        this.exposePulsarAdminClientEnabled = exposePulsarAdminClientEnabled;
    }

    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public void setAdditionalJavaRuntimeArguments(List<String> additionalJavaRuntimeArguments) {
        this.additionalJavaRuntimeArguments = additionalJavaRuntimeArguments;
    }

    public void setIgnoreUnknownConfigFields(boolean ignoreUnknownConfigFields) {
        this.ignoreUnknownConfigFields = ignoreUnknownConfigFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstanceConfig)) {
            return false;
        }
        InstanceConfig other = (InstanceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInstanceId() != other.getInstanceId()) {
            return false;
        }
        if (this.getMaxBufferedTuples() != other.getMaxBufferedTuples()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        if (this.getMaxPendingAsyncRequests() != other.getMaxPendingAsyncRequests()) {
            return false;
        }
        if (this.isExposePulsarAdminClientEnabled() != other.isExposePulsarAdminClientEnabled()) {
            return false;
        }
        if (this.getMetricsPort() != other.getMetricsPort()) {
            return false;
        }
        if (this.isIgnoreUnknownConfigFields() != other.isIgnoreUnknownConfigFields()) {
            return false;
        }
        String this$functionId = this.getFunctionId();
        String other$functionId = other.getFunctionId();
        if (this$functionId == null ? other$functionId != null : !this$functionId.equals(other$functionId)) {
            return false;
        }
        String this$transformFunctionId = this.getTransformFunctionId();
        String other$transformFunctionId = other.getTransformFunctionId();
        if (this$transformFunctionId == null ? other$transformFunctionId != null : !this$transformFunctionId.equals(other$transformFunctionId)) {
            return false;
        }
        String this$functionVersion = this.getFunctionVersion();
        String other$functionVersion = other.getFunctionVersion();
        if (this$functionVersion == null ? other$functionVersion != null : !this$functionVersion.equals(other$functionVersion)) {
            return false;
        }
        Function.FunctionDetails this$functionDetails = this.getFunctionDetails();
        Function.FunctionDetails other$functionDetails = other.getFunctionDetails();
        if (this$functionDetails == null ? other$functionDetails != null : !((Object)this$functionDetails).equals(other$functionDetails)) {
            return false;
        }
        Function.FunctionAuthenticationSpec this$functionAuthenticationSpec = this.getFunctionAuthenticationSpec();
        Function.FunctionAuthenticationSpec other$functionAuthenticationSpec = other.getFunctionAuthenticationSpec();
        if (this$functionAuthenticationSpec == null ? other$functionAuthenticationSpec != null : !((Object)this$functionAuthenticationSpec).equals(other$functionAuthenticationSpec)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        List<String> this$additionalJavaRuntimeArguments = this.getAdditionalJavaRuntimeArguments();
        List<String> other$additionalJavaRuntimeArguments = other.getAdditionalJavaRuntimeArguments();
        return !(this$additionalJavaRuntimeArguments == null ? other$additionalJavaRuntimeArguments != null : !((Object)this$additionalJavaRuntimeArguments).equals(other$additionalJavaRuntimeArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstanceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInstanceId();
        result = result * 59 + this.getMaxBufferedTuples();
        result = result * 59 + this.getPort();
        result = result * 59 + this.getMaxPendingAsyncRequests();
        result = result * 59 + (this.isExposePulsarAdminClientEnabled() ? 79 : 97);
        result = result * 59 + this.getMetricsPort();
        result = result * 59 + (this.isIgnoreUnknownConfigFields() ? 79 : 97);
        String $functionId = this.getFunctionId();
        result = result * 59 + ($functionId == null ? 43 : $functionId.hashCode());
        String $transformFunctionId = this.getTransformFunctionId();
        result = result * 59 + ($transformFunctionId == null ? 43 : $transformFunctionId.hashCode());
        String $functionVersion = this.getFunctionVersion();
        result = result * 59 + ($functionVersion == null ? 43 : $functionVersion.hashCode());
        Function.FunctionDetails $functionDetails = this.getFunctionDetails();
        result = result * 59 + ($functionDetails == null ? 43 : ((Object)$functionDetails).hashCode());
        Function.FunctionAuthenticationSpec $functionAuthenticationSpec = this.getFunctionAuthenticationSpec();
        result = result * 59 + ($functionAuthenticationSpec == null ? 43 : ((Object)$functionAuthenticationSpec).hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        List<String> $additionalJavaRuntimeArguments = this.getAdditionalJavaRuntimeArguments();
        result = result * 59 + ($additionalJavaRuntimeArguments == null ? 43 : ((Object)$additionalJavaRuntimeArguments).hashCode());
        return result;
    }

    public String toString() {
        return "InstanceConfig(instanceId=" + this.getInstanceId() + ", functionId=" + this.getFunctionId() + ", transformFunctionId=" + this.getTransformFunctionId() + ", functionVersion=" + this.getFunctionVersion() + ", functionDetails=" + this.getFunctionDetails() + ", maxBufferedTuples=" + this.getMaxBufferedTuples() + ", functionAuthenticationSpec=" + this.getFunctionAuthenticationSpec() + ", port=" + this.getPort() + ", clusterName=" + this.getClusterName() + ", maxPendingAsyncRequests=" + this.getMaxPendingAsyncRequests() + ", exposePulsarAdminClientEnabled=" + this.isExposePulsarAdminClientEnabled() + ", metricsPort=" + this.getMetricsPort() + ", additionalJavaRuntimeArguments=" + this.getAdditionalJavaRuntimeArguments() + ", ignoreUnknownConfigFields=" + this.isIgnoreUnknownConfigFields() + ")";
    }

    public boolean isExposePulsarAdminClientEnabled() {
        return this.exposePulsarAdminClientEnabled;
    }
}

