/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.customProperties;

import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.BeanProperty;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitor;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.factories.ObjectVisitorDecorator;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.factories.VisitorContext;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.factories.WrapperFactory;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.validation.AnnotationConstraintResolver;
import org.apache.pulsar.functions.runtime.shaded.com.fasterxml.jackson.module.jsonSchema.validation.ValidationConstraintResolver;

public class ValidationSchemaFactoryWrapper
extends SchemaFactoryWrapper {
    private ValidationConstraintResolver constraintResolver;

    public ValidationSchemaFactoryWrapper() {
        this(new AnnotationConstraintResolver());
    }

    public ValidationSchemaFactoryWrapper(ValidationConstraintResolver constraintResolver) {
        super(new ValidationSchemaFactoryWrapperFactory());
        this.constraintResolver = constraintResolver;
    }

    @Override
    public JsonObjectFormatVisitor expectObjectFormat(JavaType convertedType) {
        return new ObjectVisitorDecorator((ObjectVisitor)super.expectObjectFormat(convertedType)){

            private JsonSchema getPropertySchema(BeanProperty writer) {
                return ((ObjectSchema)this.getSchema()).getProperties().get(writer.getName());
            }

            @Override
            public void optionalProperty(BeanProperty writer) throws JsonMappingException {
                super.optionalProperty(writer);
                ValidationSchemaFactoryWrapper.this.addValidationConstraints(this.getPropertySchema(writer), writer);
            }

            @Override
            public void property(BeanProperty writer) throws JsonMappingException {
                super.property(writer);
                ValidationSchemaFactoryWrapper.this.addValidationConstraints(this.getPropertySchema(writer), writer);
            }
        };
    }

    protected JsonSchema addValidationConstraints(JsonSchema schema, BeanProperty prop) {
        Boolean required = this.constraintResolver.getRequired(prop);
        if (required != null) {
            schema.setRequired(required);
        }
        if (schema.isArraySchema()) {
            ArraySchema arraySchema = schema.asArraySchema();
            arraySchema.setMaxItems(this.constraintResolver.getArrayMaxItems(prop));
            arraySchema.setMinItems(this.constraintResolver.getArrayMinItems(prop));
        } else if (schema.isNumberSchema()) {
            NumberSchema numberSchema = schema.asNumberSchema();
            numberSchema.setMaximum(this.constraintResolver.getNumberMaximum(prop));
            numberSchema.setMinimum(this.constraintResolver.getNumberMinimum(prop));
        } else if (schema.isStringSchema()) {
            StringSchema stringSchema = schema.asStringSchema();
            stringSchema.setMaxLength(this.constraintResolver.getStringMaxLength(prop));
            stringSchema.setMinLength(this.constraintResolver.getStringMinLength(prop));
            stringSchema.setPattern(this.constraintResolver.getStringPattern(prop));
        }
        return schema;
    }

    private static class ValidationSchemaFactoryWrapperFactory
    extends WrapperFactory {
        private ValidationSchemaFactoryWrapperFactory() {
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p) {
            ValidationSchemaFactoryWrapper wrapper = new ValidationSchemaFactoryWrapper();
            wrapper.setProvider(p);
            return wrapper;
        }

        @Override
        public SchemaFactoryWrapper getWrapper(SerializerProvider p, VisitorContext rvc) {
            ValidationSchemaFactoryWrapper wrapper = new ValidationSchemaFactoryWrapper();
            wrapper.setProvider(p);
            wrapper.setVisitorContext(rvc);
            return wrapper;
        }
    }
}

