/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.params;

import org.apache.pulsar.functions.runtime.shaded.com.scurrilous.circe.HashParameters;

public class CrcParameters
implements HashParameters {
    private final String name;
    private final int bitWidth;
    private final long polynomial;
    private final long initial;
    private final long xorOut;
    private final boolean reflected;
    public static final CrcParameters CRC16 = new CrcParameters("CRC-16", 16, 32773L, 0L, 0L, true);
    public static final CrcParameters CRC16_CCITT = new CrcParameters("CRC-16/CCITT", 16, 4129L, 0L, 0L, true);
    public static final CrcParameters CRC16_XMODEM = new CrcParameters("CRC-16/XMODEM", 16, 4129L, 0L, 0L, false);
    public static final CrcParameters CRC32 = new CrcParameters("CRC-32", 32, 79764919L, -1L, -1L, true);
    public static final CrcParameters CRC32_BZIP2 = new CrcParameters("CRC-32/BZIP2", 32, 79764919L, -1L, -1L, false);
    public static final CrcParameters CRC32C = new CrcParameters("CRC-32C", 32, 517762881L, -1L, -1L, true);
    public static final CrcParameters CRC32_MPEG2 = new CrcParameters("CRC-32/MPEG-2", 32, 79764919L, -1L, 0L, false);
    public static final CrcParameters CRC32_POSIX = new CrcParameters("CRC-32/POSIX", 32, 79764919L, 0L, -1L, false);
    public static final CrcParameters CRC64 = new CrcParameters("CRC-64", 64, 4823603603198064275L, 0L, 0L, false);
    public static final CrcParameters CRC64_XZ = new CrcParameters("CRC-64/XZ", 64, 4823603603198064275L, -1L, -1L, true);

    public CrcParameters(String name, int bitWidth, long polynomial, long initial, long xorOut, boolean reflected) {
        if (bitWidth < 1 || bitWidth > 64) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.bitWidth = bitWidth;
        long mask = bitWidth < 64 ? (1L << bitWidth) - 1L : -1L;
        this.polynomial = polynomial & mask;
        this.initial = initial & mask;
        this.xorOut = xorOut & mask;
        this.reflected = reflected;
    }

    @Override
    public String algorithm() {
        return this.name;
    }

    public int bitWidth() {
        return this.bitWidth;
    }

    public long polynomial() {
        return this.polynomial;
    }

    public long initial() {
        return this.initial;
    }

    public long xorOut() {
        return this.xorOut;
    }

    public boolean reflected() {
        return this.reflected;
    }

    public boolean match(int bitWidth, long polynomial, long initial, long xorOut, boolean reflected) {
        return bitWidth == this.bitWidth && polynomial == this.polynomial && initial == this.initial && xorOut == this.xorOut && reflected == this.reflected;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CrcParameters other = (CrcParameters)obj;
        return this.bitWidth == other.bitWidth && this.polynomial == other.polynomial && this.initial == other.initial && this.xorOut == other.xorOut && this.reflected == other.reflected;
    }

    public int hashCode() {
        return (int)(this.polynomial ^ this.polynomial >>> 32 ^ this.initial ^ this.initial >>> 32 ^ this.xorOut ^ this.xorOut >>> 32) ^ (this.reflected ? -1 : 0);
    }
}

