/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.hash;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;

public class MurmurHash {
    public static int hash32(ByteBuf data, int offset, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int len4 = length >> 2;
        for (int i = 0; i < len4; ++i) {
            int i4 = i << 2;
            int k = data.getByte(offset + i4 + 3);
            k <<= 8;
            k |= data.getByte(offset + i4 + 2) & 0xFF;
            k <<= 8;
            k |= data.getByte(offset + i4 + 1) & 0xFF;
            k <<= 8;
            k |= data.getByte(offset + i4 + 0) & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int lenM = len4 << 2;
        int left = length - lenM;
        if (left != 0) {
            if (left >= 3) {
                h ^= data.getByte(offset + length - 3) << 16;
            }
            if (left >= 2) {
                h ^= data.getByte(offset + length - 2) << 8;
            }
            if (left >= 1) {
                h ^= data.getByte(offset + length - 1);
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }

    public static long hash64(ByteBuf key, int offset, int length, long seed) {
        long m64 = -4132994306676758123L;
        int r64 = 47;
        long h64 = seed & 0xFFFFFFFFL ^ m64 * (long)length;
        int lenLongs = length >> 3;
        for (int i = 0; i < lenLongs; ++i) {
            int i8 = i << 3;
            long k64 = ((long)key.getByte(offset + i8 + 0) & 0xFFL) + (((long)key.getByte(offset + i8 + 1) & 0xFFL) << 8) + (((long)key.getByte(offset + i8 + 2) & 0xFFL) << 16) + (((long)key.getByte(offset + i8 + 3) & 0xFFL) << 24) + (((long)key.getByte(offset + i8 + 4) & 0xFFL) << 32) + (((long)key.getByte(offset + i8 + 5) & 0xFFL) << 40) + (((long)key.getByte(offset + i8 + 6) & 0xFFL) << 48) + (((long)key.getByte(offset + i8 + 7) & 0xFFL) << 56);
            k64 *= m64;
            k64 ^= k64 >>> r64;
            h64 ^= (k64 *= m64);
            h64 *= m64;
        }
        int rem = length & 7;
        switch (rem) {
            case 0: {
                break;
            }
            case 7: {
                h64 ^= (long)key.getByte(offset + length - rem + 6) << 48;
            }
            case 6: {
                h64 ^= (long)key.getByte(offset + length - rem + 5) << 40;
            }
            case 5: {
                h64 ^= (long)key.getByte(offset + length - rem + 4) << 32;
            }
            case 4: {
                h64 ^= (long)key.getByte(offset + length - rem + 3) << 24;
            }
            case 3: {
                h64 ^= (long)key.getByte(offset + length - rem + 2) << 16;
            }
            case 2: {
                h64 ^= (long)key.getByte(offset + length - rem + 1) << 8;
            }
            case 1: {
                h64 ^= (long)key.getByte(offset + length - rem);
                h64 *= m64;
            }
        }
        h64 ^= h64 >>> r64;
        h64 *= m64;
        h64 ^= h64 >>> r64;
        return h64;
    }
}

