/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.impl.codecs;

import org.apache.pulsar.functions.runtime.shaded.io.grpc.netty.shaded.io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.buffer.Buffer;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.MessageCodec;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.ReplyException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.eventbus.ReplyFailure;

public class ReplyExceptionMessageCodec
implements MessageCodec<ReplyException, ReplyException> {
    @Override
    public void encodeToWire(Buffer buffer, ReplyException body) {
        buffer.appendByte((byte)body.failureType().toInt());
        buffer.appendInt(body.failureCode());
        if (body.getMessage() == null) {
            buffer.appendByte((byte)0);
        } else {
            buffer.appendByte((byte)1);
            byte[] encoded = body.getMessage().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(encoded.length);
            buffer.appendBytes(encoded);
        }
    }

    @Override
    public ReplyException decodeFromWire(int pos, Buffer buffer) {
        String message;
        boolean isNull;
        byte i = buffer.getByte(pos);
        ReplyFailure rf = ReplyFailure.fromInt(i);
        int failureCode = buffer.getInt(++pos);
        boolean bl = isNull = buffer.getByte(pos += 4) == 0;
        if (!isNull) {
            int strLength = buffer.getInt(++pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
            message = new String(bytes, CharsetUtil.UTF_8);
        } else {
            message = null;
        }
        return new ReplyException(rf, failureCode, message);
    }

    @Override
    public ReplyException transform(ReplyException exception) {
        return exception;
    }

    @Override
    public String name() {
        return "replyexception";
    }

    @Override
    public byte systemCodecID() {
        return 15;
    }
}

